/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion.purity;

import com.examples.with.different.packagename.purity.ImpureRandomness;
import java.util.Map;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.backend.DebugStatisticsBackend;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.objectweb.asm.Type;

public class TestImpureRandomness
extends SystemTest {
    private final boolean DEFAULT_PURE_INSPECTORS = Properties.PURE_INSPECTORS;
    private final boolean DEFAULT_ASSERTIONS = Properties.ASSERTIONS;
    private final boolean DEFAULT_SANDBOX = Properties.SANDBOX;
    private final boolean DEFAULT_RESET_STATIC_FIELDS = Properties.RESET_STATIC_FIELDS;
    private final boolean DEFAULT_REPLACE_CALLS = Properties.REPLACE_CALLS;
    private final boolean DEFAULT_JUNIT_CHECK = Properties.JUNIT_CHECK;
    private final boolean DEFAULT_JUNIT_TESTS = Properties.JUNIT_TESTS;
    private final boolean DEFAULT_JUNIT_CHECK_ON_SEPARATE_PROCESS = Properties.JUNIT_CHECK_ON_SEPARATE_PROCESS;

    @Before
    public void saveProperties() {
        Properties.SANDBOX = true;
        Properties.ASSERTIONS = false;
        Properties.JUNIT_TESTS = true;
        Properties.PURE_INSPECTORS = true;
        Properties.RESET_STATIC_FIELDS = true;
        Properties.REPLACE_CALLS = true;
        Properties.JUNIT_CHECK = true;
        Properties.JUNIT_CHECK_ON_SEPARATE_PROCESS = false;
    }

    @After
    public void restoreProperties() {
        Properties.SANDBOX = this.DEFAULT_SANDBOX;
        Properties.ASSERTIONS = this.DEFAULT_ASSERTIONS;
        Properties.JUNIT_TESTS = this.DEFAULT_JUNIT_TESTS;
        Properties.PURE_INSPECTORS = this.DEFAULT_PURE_INSPECTORS;
        Properties.RESET_STATIC_FIELDS = this.DEFAULT_RESET_STATIC_FIELDS;
        Properties.REPLACE_CALLS = this.DEFAULT_REPLACE_CALLS;
        Properties.JUNIT_CHECK = this.DEFAULT_JUNIT_CHECK;
        Properties.JUNIT_CHECK_ON_SEPARATE_PROCESS = this.DEFAULT_JUNIT_CHECK_ON_SEPARATE_PROCESS;
    }

    @Test
    public void test() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ImpureRandomness.class.getCanonicalName();
        Properties.OUTPUT_VARIABLES = "" + RuntimeVariable.HadUnstableTests;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        double best_fitness = best.getFitness();
        Assert.assertTrue((String)"Optimal coverage was not achieved ", (best_fitness == 0.0 ? 1 : 0) != 0);
        CheapPurityAnalyzer purityAnalyzer = CheapPurityAnalyzer.getInstance();
        String intTypeDescriptor = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
        boolean randomNextInt = purityAnalyzer.isPure(targetClass, "randomNextInt", intTypeDescriptor);
        Assert.assertFalse((boolean)randomNextInt);
        boolean secureRandomNextInt = purityAnalyzer.isPure(targetClass, "secureRandomNextInt", intTypeDescriptor);
        Assert.assertFalse((boolean)secureRandomNextInt);
        String stringTypeDescriptor = Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]);
        boolean randomUUIDToString = purityAnalyzer.isPure(targetClass, "randomUUIDToString", stringTypeDescriptor);
        Assert.assertFalse((boolean)randomUUIDToString);
        String doubleTypeDescriptor = Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]);
        boolean randomMath = purityAnalyzer.isPure(targetClass, "randomMath", doubleTypeDescriptor);
        Assert.assertFalse((boolean)randomMath);
        Map map = DebugStatisticsBackend.getLatestWritten();
        Assert.assertNotNull((Object)map);
        OutputVariable unstable = (OutputVariable)map.get(RuntimeVariable.HadUnstableTests.toString());
        Assert.assertNotNull((Object)unstable);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)unstable.getValue());
    }
}

