/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job;

import com.examples.with.different.packagename.continuous.Simple;
import com.examples.with.different.packagename.continuous.Trivial;
import com.examples.with.different.packagename.continuous.UsingSimpleAndTrivial;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.continuous.CtgConfiguration;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobExecutor;
import org.evosuite.continuous.persistency.StorageManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorTest {
    private StorageManager storage;

    @Before
    public void init() {
        if (this.storage != null) {
            this.storage.clean();
        }
        this.storage = new StorageManager(".tmp_for_testing_" + this.getClass().getName());
        this.storage.clean();
    }

    @Test(timeout=90000L)
    public void testActualExecutionOfSchedule() {
        Properties.TEST_SCAFFOLDING = true;
        boolean storageOK = this.storage.openForWriting();
        Assert.assertTrue((boolean)storageOK);
        storageOK = this.storage.createNewTmpFolders();
        Assert.assertTrue((boolean)storageOK);
        List data = this.storage.gatherGeneratedTestsOnDisk();
        Assert.assertEquals((long)0L, (long)data.size());
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        String classpath = ClassPathHandler.getInstance().getTargetProjectClasspath();
        int cores = 1;
        int memory = 1000;
        int minutes = 1;
        CtgConfiguration conf = new CtgConfiguration(memory, cores, minutes, 1, false, Properties.AvailableSchedule.SIMPLE);
        JobExecutor exe = new JobExecutor(this.storage, classpath, conf);
        JobDefinition simple = new JobDefinition(30, memory, Simple.class.getName(), 0, null, null);
        JobDefinition trivial = new JobDefinition(30, memory, Trivial.class.getName(), 0, null, null);
        Assert.assertTrue((simple.jobID < trivial.jobID ? 1 : 0) != 0);
        List<JobDefinition> jobs = Arrays.asList(simple, trivial);
        exe.executeJobs(jobs, cores);
        exe.waitForJobs();
        data = this.storage.gatherGeneratedTestsOnDisk();
        Assert.assertEquals((String)("Tmp folder: " + this.storage.getTmpFolder()), (long)4L, (long)data.size());
        this.storage.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventSequeneWhenWrongSchedule() throws InterruptedException {
        boolean storageOK = this.storage.openForWriting();
        Assert.assertTrue((boolean)storageOK);
        storageOK = this.storage.createNewTmpFolders();
        Assert.assertTrue((boolean)storageOK);
        List data = this.storage.gatherGeneratedTestsOnDisk();
        Assert.assertEquals((long)0L, (long)data.size());
        String classpath = System.getProperty("java.class.path");
        int cores = 1;
        int memory = 1000;
        int minutes = 10000;
        CtgConfiguration conf = new CtgConfiguration(memory, cores, minutes, 1, false, Properties.AvailableSchedule.SIMPLE);
        final JobExecutor exe = new JobExecutor(this.storage, classpath, conf);
        JobDefinition simple = new JobDefinition(30, memory, Simple.class.getName(), 0, null, null);
        JobDefinition trivial = new JobDefinition(30, memory, Trivial.class.getName(), 0, null, null);
        JobDefinition ust = new JobDefinition(30, memory, UsingSimpleAndTrivial.class.getName(), 0, new HashSet<String>(Arrays.asList(Simple.class.getName(), Trivial.class.getName())), null);
        final List<JobDefinition> jobs = Arrays.asList(simple, ust, trivial);
        exe.initExecution(jobs);
        Thread t = new Thread(){

            @Override
            public void run() {
                exe.execute(jobs);
            }
        };
        try {
            t.start();
            exe.doneWithJob(exe.pollJob());
            exe.doneWithJob(exe.pollJob());
            JobDefinition last = exe.pollJob();
            exe.doneWithJob(last);
            Assert.assertEquals((Object)ust.cut, (Object)last.cut);
        }
        finally {
            t.interrupt();
        }
    }
}

