/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job;

import com.examples.with.different.packagename.continuous.BaseForSeeding;
import com.examples.with.different.packagename.continuous.MoreBranches;
import com.examples.with.different.packagename.continuous.NoBranches;
import com.examples.with.different.packagename.continuous.OnlyAbstract;
import com.examples.with.different.packagename.continuous.OnlyAbstractImpl;
import com.examples.with.different.packagename.continuous.Simple;
import com.examples.with.different.packagename.continuous.SomeBranches;
import com.examples.with.different.packagename.continuous.SomeInterface;
import com.examples.with.different.packagename.continuous.SomeInterfaceImpl;
import com.examples.with.different.packagename.continuous.Trivial;
import com.examples.with.different.packagename.continuous.UsingSimpleAndTrivial;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.continuous.CtgConfiguration;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.project.ProjectAnalyzer;
import org.evosuite.continuous.project.ProjectStaticData;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JobSchedulerTest {
    @BeforeClass
    public static void initClass() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
    }

    @Test
    public void testBudget() {
        String[] cuts = new String[]{SomeInterface.class.getName(), NoBranches.class.getName(), SomeBranches.class.getName(), MoreBranches.class.getName()};
        ProjectAnalyzer analyzer = new ProjectAnalyzer(cuts);
        ProjectStaticData data = analyzer.analyze();
        int cores = 2;
        int memory = 1400;
        int budget = 2;
        CtgConfiguration conf = new CtgConfiguration(memory, cores, budget, 1, false, Properties.AvailableSchedule.BUDGET);
        JobScheduler scheduler = new JobScheduler(data, conf);
        List jobs = scheduler.createNewSchedule();
        Assert.assertNotNull((Object)jobs);
        Assert.assertEquals((long)3L, (long)jobs.size());
        for (JobDefinition job : jobs) {
            Assert.assertEquals((long)700L, (long)job.memoryInMB);
        }
        Assert.assertEquals((Object)MoreBranches.class.getName(), (Object)((JobDefinition)jobs.get((int)0)).cut);
        Assert.assertEquals((Object)SomeBranches.class.getName(), (Object)((JobDefinition)jobs.get((int)1)).cut);
        Assert.assertEquals((Object)NoBranches.class.getName(), (Object)((JobDefinition)jobs.get((int)2)).cut);
        long dif01 = ((JobDefinition)jobs.get((int)0)).seconds - ((JobDefinition)jobs.get((int)1)).seconds;
        long dif12 = ((JobDefinition)jobs.get((int)1)).seconds - ((JobDefinition)jobs.get((int)2)).seconds;
        Assert.assertTrue((String)("" + dif01), (dif01 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("" + dif12), (dif12 > 0L ? 1 : 0) != 0);
        int sum = ((JobDefinition)jobs.get((int)0)).seconds + ((JobDefinition)jobs.get((int)1)).seconds + ((JobDefinition)jobs.get((int)2)).seconds;
        Assert.assertTrue((String)("wrong value " + sum), (sum <= cores * budget * 60 ? 1 : 0) != 0);
    }

    @Test
    public void testNonExceedingBudget() {
        String[] cuts = new String[]{NoBranches.class.getName(), Trivial.class.getName(), MoreBranches.class.getName()};
        ProjectAnalyzer analyzer = new ProjectAnalyzer(cuts);
        ProjectStaticData data = analyzer.analyze();
        int cores = 2;
        int memory = 1400;
        int budget = 10;
        CtgConfiguration conf = new CtgConfiguration(memory, cores, budget, 1, false, Properties.AvailableSchedule.BUDGET);
        JobScheduler scheduler = new JobScheduler(data, conf);
        List jobs = scheduler.createNewSchedule();
        Assert.assertNotNull((Object)jobs);
        Assert.assertEquals((long)3L, (long)jobs.size());
        for (JobDefinition job : jobs) {
            Assert.assertEquals((long)700L, (long)job.memoryInMB);
        }
        Assert.assertEquals((Object)MoreBranches.class.getName(), (Object)((JobDefinition)jobs.get((int)0)).cut);
        Assert.assertEquals((Object)Trivial.class.getName(), (Object)((JobDefinition)jobs.get((int)1)).cut);
        Assert.assertEquals((Object)NoBranches.class.getName(), (Object)((JobDefinition)jobs.get((int)2)).cut);
        long dif01 = ((JobDefinition)jobs.get((int)0)).seconds - ((JobDefinition)jobs.get((int)1)).seconds;
        long dif12 = ((JobDefinition)jobs.get((int)1)).seconds - ((JobDefinition)jobs.get((int)2)).seconds;
        Assert.assertTrue((String)("" + dif01), (dif01 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("" + dif12), (dif12 > 0L ? 1 : 0) != 0);
        int sum = ((JobDefinition)jobs.get((int)0)).seconds + ((JobDefinition)jobs.get((int)1)).seconds + ((JobDefinition)jobs.get((int)2)).seconds;
        Assert.assertTrue((String)("wrong value " + sum), (sum <= cores * budget * 60 ? 1 : 0) != 0);
        for (JobDefinition job : jobs) {
            Assert.assertTrue((String)("wrong " + job.seconds), (job.seconds <= budget * 60 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSimple() {
        String[] cuts = new String[]{SomeInterface.class.getName(), NoBranches.class.getName(), SomeBranches.class.getName(), MoreBranches.class.getName()};
        ProjectAnalyzer analyzer = new ProjectAnalyzer(cuts);
        ProjectStaticData data = analyzer.analyze();
        int cores = 2;
        int memory = 1400;
        int budget = 2;
        CtgConfiguration conf = new CtgConfiguration(memory, cores, budget, 1, false, Properties.AvailableSchedule.SIMPLE);
        JobScheduler scheduler = new JobScheduler(data, conf);
        List jobs = scheduler.createNewSchedule();
        Assert.assertNotNull((Object)jobs);
        Assert.assertEquals((long)3L, (long)jobs.size());
        for (JobDefinition job : jobs) {
            Assert.assertEquals((long)700L, (long)job.memoryInMB);
        }
        Assert.assertEquals((long)((JobDefinition)jobs.get((int)0)).seconds, (long)((JobDefinition)jobs.get((int)1)).seconds);
        Assert.assertEquals((long)((JobDefinition)jobs.get((int)2)).seconds, (long)((JobDefinition)jobs.get((int)1)).seconds);
        int sum = ((JobDefinition)jobs.get((int)0)).seconds + ((JobDefinition)jobs.get((int)1)).seconds + ((JobDefinition)jobs.get((int)2)).seconds;
        Assert.assertTrue((String)("wrong value " + sum), (sum <= cores * budget * 60 ? 1 : 0) != 0);
    }

    @Test
    public void testSeeding() {
        String[] cuts = new String[]{BaseForSeeding.class.getName(), NoBranches.class.getName(), MoreBranches.class.getName(), SomeInterface.class.getName(), SomeInterfaceImpl.class.getName(), SomeBranches.class.getName(), OnlyAbstract.class.getName(), OnlyAbstractImpl.class.getName(), Trivial.class.getName()};
        ProjectAnalyzer analyzer = new ProjectAnalyzer(cuts);
        ProjectStaticData data = analyzer.analyze();
        int cores = 3;
        int memory = 1800;
        int budget = 3;
        CtgConfiguration conf = new CtgConfiguration(memory, cores, budget, 1, false, Properties.AvailableSchedule.SEEDING);
        JobScheduler scheduler = new JobScheduler(data, conf);
        List jobs = scheduler.createNewSchedule();
        Assert.assertNotNull((Object)jobs);
        for (JobDefinition job : jobs) {
            Assert.assertEquals((long)600L, (long)job.memoryInMB);
        }
        Assert.assertEquals((String)("Wrong number of jobs: " + jobs.toString()), (long)8L, (long)jobs.size());
        JobDefinition seeding = null;
        for (JobDefinition job : jobs) {
            if (!job.cut.equals(BaseForSeeding.class.getName())) continue;
            seeding = job;
            break;
        }
        Assert.assertNotNull(seeding);
        Set in = seeding.inputClasses;
        Assert.assertNotNull((Object)in);
        System.out.println(in.toString());
        Assert.assertTrue((boolean)in.contains(NoBranches.class.getName()));
        Assert.assertTrue((boolean)in.contains(SomeBranches.class.getName()));
        Assert.assertTrue((boolean)in.contains(SomeInterfaceImpl.class.getName()));
        Assert.assertTrue((boolean)in.contains(OnlyAbstractImpl.class.getName()));
        Assert.assertEquals((long)5L, (long)in.size());
    }

    @Test
    public void testSeedingOrder() {
        String[] cuts = new String[]{Simple.class.getName(), UsingSimpleAndTrivial.class.getName(), Trivial.class.getName()};
        ProjectAnalyzer analyzer = new ProjectAnalyzer(cuts);
        ProjectStaticData data = analyzer.analyze();
        int cores = 3;
        int memory = 1800;
        int budget = 2;
        CtgConfiguration conf = new CtgConfiguration(memory, cores, budget, 1, false, Properties.AvailableSchedule.SEEDING);
        JobScheduler scheduler = new JobScheduler(data, conf);
        List jobs = scheduler.createNewSchedule();
        Assert.assertNotNull((Object)jobs);
        Assert.assertEquals((String)("Wrong number of jobs: " + jobs.toString()), (long)3L, (long)jobs.size());
        JobDefinition seeding = (JobDefinition)jobs.get(2);
        Assert.assertNotNull((Object)seeding);
        Assert.assertEquals((Object)UsingSimpleAndTrivial.class.getName(), (Object)seeding.cut);
        Set in = seeding.inputClasses;
        Assert.assertNotNull((Object)in);
        System.out.println(in.toString());
        Assert.assertTrue((boolean)in.contains(Simple.class.getName()));
        Assert.assertTrue((boolean)in.contains(Trivial.class.getName()));
        Assert.assertEquals((long)2L, (long)in.size());
    }

    @Test
    public void testSeedingAndBudget() {
        String[] cuts = new String[]{Trivial.class.getName(), UsingSimpleAndTrivial.class.getName(), Simple.class.getName()};
        ProjectAnalyzer analyzer = new ProjectAnalyzer(cuts);
        ProjectStaticData data = analyzer.analyze();
        int cores = 2;
        int memory = 1800;
        int budget = 3;
        CtgConfiguration conf = new CtgConfiguration(memory, cores, budget, 1, false, Properties.AvailableSchedule.BUDGET_AND_SEEDING);
        JobScheduler scheduler = new JobScheduler(data, conf);
        List jobs = scheduler.createNewSchedule();
        Assert.assertNotNull((Object)jobs);
        Assert.assertEquals((String)("Wrong number of jobs: " + jobs.toString()), (long)3L, (long)jobs.size());
        JobDefinition seeding = (JobDefinition)jobs.get(2);
        Assert.assertNotNull((Object)seeding);
        Assert.assertEquals((Object)UsingSimpleAndTrivial.class.getName(), (Object)seeding.cut);
        Set in = seeding.inputClasses;
        Assert.assertNotNull((Object)in);
        System.out.println(in.toString());
        Assert.assertTrue((boolean)in.contains(Simple.class.getName()));
        Assert.assertTrue((boolean)in.contains(Trivial.class.getName()));
        Assert.assertEquals((long)2L, (long)in.size());
        JobDefinition simple = (JobDefinition)jobs.get(0);
        Assert.assertNotNull((Object)simple);
        Assert.assertEquals((Object)Simple.class.getName(), (Object)simple.cut);
        int simpleTime = ((JobDefinition)jobs.get((int)0)).seconds;
        int trivialTime = ((JobDefinition)jobs.get((int)1)).seconds;
        int seedingTime = ((JobDefinition)jobs.get((int)2)).seconds;
        System.out.println("Ordered times: " + simpleTime + ", " + trivialTime + ", " + seedingTime);
        Assert.assertTrue((simpleTime > trivialTime ? 1 : 0) != 0);
        Assert.assertTrue((simpleTime < seedingTime ? 1 : 0) != 0);
        Assert.assertTrue((trivialTime < seedingTime ? 1 : 0) != 0);
    }
}

