/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job.schedule;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.schedule.SeedingSchedule;
import org.junit.Assert;
import org.junit.Test;

public class SeedingScheduleTest {
    @Test
    public void testSortingOneDependency() {
        HashSet<String> dep1 = new HashSet<String>(Arrays.asList("e"));
        JobDefinition a = new JobDefinition(1, 1, "a", 0, dep1, null);
        JobDefinition b = new JobDefinition(1, 1, "b", 0, null, null);
        JobDefinition c = new JobDefinition(1, 1, "c", 0, null, null);
        JobDefinition d = new JobDefinition(1, 1, "d", 0, null, null);
        JobDefinition e = new JobDefinition(1, 1, "e", 0, null, null);
        List jobs = Arrays.asList(a, b, c, d, e);
        jobs = SeedingSchedule.getSortedToSatisfyDependencies(jobs);
        Assert.assertEquals((Object)"b", (Object)((JobDefinition)jobs.get((int)0)).cut);
        Assert.assertEquals((Object)"c", (Object)((JobDefinition)jobs.get((int)1)).cut);
        Assert.assertEquals((Object)"d", (Object)((JobDefinition)jobs.get((int)2)).cut);
        Assert.assertEquals((Object)"e", (Object)((JobDefinition)jobs.get((int)3)).cut);
        Assert.assertEquals((Object)"a", (Object)((JobDefinition)jobs.get((int)4)).cut);
    }

    @Test
    public void testSortingTwoDependencies() {
        HashSet<String> dep1 = new HashSet<String>(Arrays.asList("e"));
        HashSet<String> dep2 = new HashSet<String>(Arrays.asList("a", "c"));
        JobDefinition a = new JobDefinition(1, 1, "a", 0, dep1, null);
        JobDefinition b = new JobDefinition(1, 1, "b", 0, dep2, null);
        JobDefinition c = new JobDefinition(1, 1, "c", 0, null, null);
        JobDefinition d = new JobDefinition(1, 1, "d", 0, null, null);
        JobDefinition e = new JobDefinition(1, 1, "e", 0, null, null);
        List jobs = Arrays.asList(a, b, c, d, e);
        jobs = SeedingSchedule.getSortedToSatisfyDependencies(jobs);
        Assert.assertEquals((Object)"c", (Object)((JobDefinition)jobs.get((int)0)).cut);
        Assert.assertEquals((Object)"d", (Object)((JobDefinition)jobs.get((int)1)).cut);
        Assert.assertEquals((Object)"e", (Object)((JobDefinition)jobs.get((int)2)).cut);
        Assert.assertEquals((Object)"a", (Object)((JobDefinition)jobs.get((int)3)).cut);
        Assert.assertEquals((Object)"b", (Object)((JobDefinition)jobs.get((int)4)).cut);
    }

    @Test
    public void testSortingPostponedDependencies() {
        HashSet<String> dep1 = new HashSet<String>(Arrays.asList("b"));
        HashSet<String> dep2 = new HashSet<String>(Arrays.asList("c"));
        JobDefinition a = new JobDefinition(1, 1, "a", 0, dep1, null);
        JobDefinition b = new JobDefinition(1, 1, "b", 0, dep2, null);
        JobDefinition c = new JobDefinition(1, 1, "c", 0, null, null);
        List jobs = Arrays.asList(a, b, c);
        jobs = SeedingSchedule.getSortedToSatisfyDependencies(jobs);
        Assert.assertEquals((Object)"c", (Object)((JobDefinition)jobs.get((int)0)).cut);
        Assert.assertEquals((Object)"b", (Object)((JobDefinition)jobs.get((int)1)).cut);
        Assert.assertEquals((Object)"a", (Object)((JobDefinition)jobs.get((int)2)).cut);
    }
}

