/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.project;

import com.examples.with.different.packagename.continuous.Simple;
import com.examples.with.different.packagename.continuous.Trivial;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.continuous.project.ProjectAnalyzer;
import org.evosuite.continuous.project.ProjectStaticData;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProjectAnalyzerTest {
    @BeforeClass
    public static void initClass() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
    }

    @Test
    public void testActualScanWithPrefix() {
        String target = "target/test-classes";
        String prefix = "com.examples";
        ProjectAnalyzer pa = new ProjectAnalyzer(target, prefix, null);
        ProjectStaticData data = pa.analyze();
        Assert.assertTrue((data.getTotalNumberOfClasses() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testActualScanWithNoPrefix() {
        String target = "target/test-classes";
        String prefix = null;
        ProjectAnalyzer pa = new ProjectAnalyzer(target, prefix, null);
        ProjectStaticData data = pa.analyze();
        Assert.assertTrue((data.getTotalNumberOfClasses() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBranches() {
        String[] cuts = new String[]{Simple.class.getName(), Trivial.class.getName()};
        ProjectAnalyzer pa = new ProjectAnalyzer(cuts);
        ProjectStaticData data = pa.analyze();
        Assert.assertEquals((long)2L, (long)data.getTotalNumberOfClasses());
        ProjectStaticData.ClassInfo simple = data.getClassInfo(Simple.class.getName());
        Assert.assertNotNull((Object)simple);
        Assert.assertEquals((long)2L, (long)simple.numberOfBranches);
        ProjectStaticData.ClassInfo trivial = data.getClassInfo(Trivial.class.getName());
        Assert.assertNotNull((Object)trivial);
        Assert.assertEquals((long)1L, (long)trivial.numberOfBranches);
    }
}

