/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.project;

import java.io.Serializable;
import java.util.Set;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.continuous.project.ProjectGraph;
import org.evosuite.continuous.project.ProjectStaticData;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProjectGraphTest {
    @BeforeClass
    public static void initClass() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
    }

    @Test
    public void testGetAllCUTsParents() {
        ProjectStaticData data = new ProjectStaticData();
        data.addNewClass(new ProjectStaticData.ClassInfo(A.class, 1, true));
        data.addNewClass(new ProjectStaticData.ClassInfo(B.class, 1, true));
        data.addNewClass(new ProjectStaticData.ClassInfo(C.class, 0, false));
        data.addNewClass(new ProjectStaticData.ClassInfo(D.class, 0, false));
        data.addNewClass(new ProjectStaticData.ClassInfo(E.class, 1, true));
        data.addNewClass(new ProjectStaticData.ClassInfo(F.class, 0, false));
        data.addNewClass(new ProjectStaticData.ClassInfo(G.class, 1, true));
        ProjectGraph graph = data.getProjectGraph();
        Set forA = graph.getAllCUTsParents(A.class.getName());
        Set forB = graph.getAllCUTsParents(B.class.getName());
        Set forC = graph.getAllCUTsParents(C.class.getName());
        Set forD = graph.getAllCUTsParents(D.class.getName());
        Set forE = graph.getAllCUTsParents(E.class.getName());
        Set forF = graph.getAllCUTsParents(F.class.getName());
        Set forG = graph.getAllCUTsParents(G.class.getName());
        Assert.assertEquals((long)0L, (long)forA.size());
        Assert.assertEquals((long)1L, (long)forB.size());
        Assert.assertEquals((long)0L, (long)forC.size());
        Assert.assertEquals((long)0L, (long)forD.size());
        Assert.assertEquals((long)0L, (long)forE.size());
        Assert.assertEquals((long)0L, (long)forF.size());
        Assert.assertEquals((long)1L, (long)forG.size());
    }

    @Test
    public void testClassTypes() {
        ProjectStaticData data = new ProjectStaticData();
        data.addNewClass(new ProjectStaticData.ClassInfo(A.class, 1, true));
        data.addNewClass(new ProjectStaticData.ClassInfo(B.class, 1, true));
        data.addNewClass(new ProjectStaticData.ClassInfo(C.class, 0, false));
        data.addNewClass(new ProjectStaticData.ClassInfo(D.class, 0, false));
        data.addNewClass(new ProjectStaticData.ClassInfo(E.class, 1, true));
        data.addNewClass(new ProjectStaticData.ClassInfo(F.class, 0, false));
        data.addNewClass(new ProjectStaticData.ClassInfo(G.class, 1, true));
        ProjectGraph graph = data.getProjectGraph();
        Assert.assertTrue((boolean)graph.isConcrete(A.class.getName()));
        Assert.assertTrue((boolean)graph.isConcrete(B.class.getName()));
        Assert.assertTrue((boolean)graph.isInterface(C.class.getName()));
        Assert.assertTrue((boolean)graph.isInterface(D.class.getName()));
        Assert.assertTrue((boolean)graph.isAbstract(E.class.getName()));
        Assert.assertTrue((boolean)graph.isInterface(F.class.getName()));
        Assert.assertTrue((boolean)graph.isAbstract(G.class.getName()));
    }

    abstract class G
    extends E
    implements F {
        G() {
        }

        @Override
        void foo() {
        }
    }

    static interface F
    extends C,
    D {
    }

    abstract class E
    implements Comparable {
        E() {
        }

        void foo() {
        }
    }

    static interface D
    extends Serializable {
    }

    static interface C {
    }

    class B
    extends A {
        B() {
        }

        @Override
        void foo() {
        }
    }

    class A {
        A() {
        }

        void foo() {
        }
    }
}

