/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import com.examples.with.different.packagename.contracts.AssertionException;
import com.examples.with.different.packagename.contracts.EqualsHashCode;
import com.examples.with.different.packagename.contracts.EqualsNull;
import com.examples.with.different.packagename.contracts.EqualsSelf;
import com.examples.with.different.packagename.contracts.EqualsSymmetric;
import com.examples.with.different.packagename.contracts.Foo;
import com.examples.with.different.packagename.contracts.FooTheories;
import com.examples.with.different.packagename.contracts.HashcodeException;
import com.examples.with.different.packagename.contracts.RaiseNullPointerException;
import com.examples.with.different.packagename.contracts.ToStringException;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.contracts.AssertionErrorContract;
import org.evosuite.contracts.EqualsContract;
import org.evosuite.contracts.EqualsHashcodeContract;
import org.evosuite.contracts.EqualsNullContract;
import org.evosuite.contracts.EqualsSymmetricContract;
import org.evosuite.contracts.FailingTestSet;
import org.evosuite.contracts.HashCodeReturnsNormallyContract;
import org.evosuite.contracts.JUnitTheoryContract;
import org.evosuite.contracts.ToStringReturnsNormallyContract;
import org.evosuite.contracts.UndeclaredExceptionContract;
import org.evosuite.testcase.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestContractGeneration
extends SystemTest {
    private boolean checkContracts = false;
    private String junitTheories = "";

    @Before
    public void storeCheckContracts() {
        this.checkContracts = Properties.CHECK_CONTRACTS;
        this.junitTheories = Properties.JUNIT_THEORIES;
        FailingTestSet.clear();
    }

    @After
    public void restoreCheckContracts() {
        Properties.CHECK_CONTRACTS = this.checkContracts;
        Properties.JUNIT_THEORIES = this.junitTheories;
    }

    @Test
    public void testEqualsNull() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = EqualsNull.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfUniqueViolations());
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfViolations(EqualsNullContract.class));
    }

    @Test
    public void testToStringException() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ToStringException.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        for (TestCase test : FailingTestSet.getFailingTests()) {
            System.out.println(test.toCode());
        }
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfViolations(ToStringReturnsNormallyContract.class));
    }

    @Test
    public void testHashCodeReturnsNormally() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = HashcodeException.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfViolations(HashCodeReturnsNormallyContract.class));
    }

    @Test
    public void testEqualsSelfContract() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = EqualsSelf.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfViolations(EqualsContract.class));
    }

    @Ignore
    @Test
    public void testAssertionContract() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = AssertionException.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfUniqueViolations());
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfViolations(AssertionErrorContract.class));
    }

    @Test
    public void testEqualsHashcodeContract() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = EqualsHashCode.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertEquals((long)4L, (long)FailingTestSet.getNumberOfUniqueViolations());
        Assert.assertTrue((FailingTestSet.getNumberOfViolations(EqualsHashcodeContract.class) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetricContract() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = EqualsSymmetric.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        for (TestCase test : FailingTestSet.getFailingTests()) {
            System.out.println(test.toString());
        }
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfViolations(EqualsSymmetricContract.class));
    }

    @Test
    public void testNullPointerExceptionContract() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = RaiseNullPointerException.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfViolations(UndeclaredExceptionContract.class));
    }

    @Test
    public void testJUnitTheoryContract() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = Foo.class.getCanonicalName();
        Properties.CHECK_CONTRACTS = true;
        Properties.JUNIT_THEORIES = FooTheories.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfUniqueViolations());
        Assert.assertEquals((long)1L, (long)FailingTestSet.getNumberOfViolations(JUnitTheoryContract.class));
    }
}

