/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import com.examples.with.different.packagename.defuse.DefUseExample1;
import com.examples.with.different.packagename.defuse.GCD;
import java.util.Arrays;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefUseAnalysis
extends SystemTest {
    private final Properties.Criterion[] oldCriterion = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length);
    private final boolean oldAssertions = Properties.ASSERTIONS;
    private final boolean DEFAULT_SANDBOX = Properties.SANDBOX;
    private final String analysisCriteria = Properties.ANALYSIS_CRITERIA;

    @Before
    public void beforeTest() {
        Properties.SANDBOX = true;
        Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.DEFUSE};
        Properties.TARGET_CLASS = DefUseExample1.class.getCanonicalName();
    }

    @After
    public void afterTest() {
        Properties.CRITERION = this.oldCriterion;
        Properties.ASSERTIONS = this.oldAssertions;
        Properties.SANDBOX = this.DEFAULT_SANDBOX;
        Properties.ANALYSIS_CRITERIA = this.analysisCriteria;
    }

    @Test
    public void testSimpleExample() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DefUseExample1.class.getCanonicalName();
        Properties.ASSERTIONS = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((long)0L, (long)DefUseCoverageFactory.getInterMethodGoalsCount());
        Assert.assertEquals((long)0L, (long)DefUseCoverageFactory.getIntraClassGoalsCount());
        Assert.assertEquals((long)1L, (long)DefUseCoverageFactory.getParamGoalsCount());
        Assert.assertEquals((long)3L, (long)DefUseCoverageFactory.getIntraMethodGoalsCount());
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testGCDExample() {
        EvoSuite evosuite = new EvoSuite();
        String targetClass = GCD.class.getCanonicalName();
        Properties.ASSERTIONS = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        System.out.println("Def: " + DefUsePool.getDefCounter());
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((long)0L, (long)DefUseCoverageFactory.getInterMethodGoalsCount());
        Assert.assertEquals((long)0L, (long)DefUseCoverageFactory.getIntraClassGoalsCount());
        Assert.assertEquals((long)4L, (long)DefUseCoverageFactory.getParamGoalsCount());
        Assert.assertEquals((long)6L, (long)DefUseCoverageFactory.getIntraMethodGoalsCount());
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }
}

