/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.line;

import com.examples.with.different.packagename.FlagExample3;
import com.examples.with.different.packagename.IntExample;
import com.examples.with.different.packagename.SingleMethod;
import com.examples.with.different.packagename.coverage.IntExampleWithNoElse;
import java.util.Arrays;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLineCoverageFitnessFunction
extends SystemTest {
    private Properties.Criterion[] oldCriteria = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length);
    private Properties.StoppingCondition oldStoppingCondition = Properties.STOPPING_CONDITION;
    private double oldPrimitivePool = Properties.PRIMITIVE_POOL;

    @Before
    public void beforeTest() {
        this.oldCriteria = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length);
        this.oldStoppingCondition = Properties.STOPPING_CONDITION;
        this.oldPrimitivePool = Properties.PRIMITIVE_POOL;
        Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.LINE};
    }

    @After
    public void restoreProperties() {
        Properties.CRITERION = this.oldCriteria;
        Properties.STOPPING_CONDITION = this.oldStoppingCondition;
        Properties.PRIMITIVE_POOL = this.oldPrimitivePool;
    }

    @Test
    public void testLineCoverageFitnessSimpleExample() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = SingleMethod.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("CoveredGoals:\n" + best.getCoveredGoals());
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((long)1L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testLineCoverageFitnessFlagExample3() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = FlagExample3.class.getCanonicalName();
        Properties.STOPPING_CONDITION = Properties.StoppingCondition.MAXTIME;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("CoveredGoals:\n" + best.getCoveredGoals());
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((long)4L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testLineCoverageFitnessBranchGuidance() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = IntExample.class.getCanonicalName();
        Properties.PRIMITIVE_POOL = 0.0;
        Properties.SEARCH_BUDGET = 50000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("CoveredGoals:\n" + best.getCoveredGoals());
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((long)5L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testLineCoverageFitnessBranchGuidance2() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = IntExampleWithNoElse.class.getCanonicalName();
        Properties.PRIMITIVE_POOL = 0.0;
        Properties.SEARCH_BUDGET = 50000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("CoveredGoals:\n" + best.getCoveredGoals());
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((long)5L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }
}

