/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import org.evosuite.Properties;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.branch.OnlyBranchCoverageSuiteFitness;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodTraceCoverageSuiteFitness;
import org.evosuite.coverage.output.OutputCoverageSuiteFitness;
import org.evosuite.coverage.statement.StatementCoverageSuiteFitness;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.Assert;
import org.junit.Test;

public class ChromosomeTest {
    private final double ANY_DOUBLE_1 = 2.0;
    private final double ANY_DOUBLE_2 = 5.0;
    private final double ANY_DOUBLE_3 = 6.0;
    private final double ANY_DOUBLE_4 = 3.0;
    private final double ANY_DOUBLE_BETWEEN_0_AND_1_1 = 0.2;
    private final double ANY_DOUBLE_BETWEEN_0_AND_1_2 = 0.6;

    @Test
    public void testGetFitnessForOneFunctionNoCompositional() {
        Properties.ALGORITHM = Properties.Algorithm.STEADYSTATEGA;
        Properties.COMPOSITIONAL_FITNESS = false;
        TestSuiteChromosome c = new TestSuiteChromosome();
        c.addFitness((FitnessFunction)new StatementCoverageSuiteFitness(), 2.0);
        c.addFitness((FitnessFunction)new BranchCoverageSuiteFitness(), 5.0);
        Assert.assertEquals((double)2.0, (double)c.getFitness(), (double)0.001);
    }

    @Test
    public void testGetFitnessForNoFunctionNoCompositional() {
        Properties.ALGORITHM = Properties.Algorithm.STEADYSTATEGA;
        Properties.COMPOSITIONAL_FITNESS = false;
        TestSuiteChromosome c = new TestSuiteChromosome();
        Assert.assertEquals((double)0.0, (double)c.getFitness(), (double)0.001);
    }

    @Test
    public void testCompositionalGetFitnessForNoFunction() {
        Properties.ALGORITHM = Properties.Algorithm.STEADYSTATEGA;
        Properties.COMPOSITIONAL_FITNESS = true;
        TestSuiteChromosome c = new TestSuiteChromosome();
        Assert.assertEquals((double)0.0, (double)c.getFitness(), (double)0.001);
    }

    @Test
    public void testCompositionalGetFitnessForOneFunction() {
        Properties.ALGORITHM = Properties.Algorithm.STEADYSTATEGA;
        Properties.COMPOSITIONAL_FITNESS = true;
        TestSuiteChromosome c = new TestSuiteChromosome();
        StatementCoverageSuiteFitness f1 = new StatementCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f1);
        c.setFitness((FitnessFunction)f1, 2.0);
        Assert.assertEquals((double)2.0, (double)c.getFitness(), (double)0.001);
    }

    @Test
    public void testCompositionalGetFitnessForTwoFunctions() {
        Properties.ALGORITHM = Properties.Algorithm.STEADYSTATEGA;
        Properties.COMPOSITIONAL_FITNESS = true;
        TestSuiteChromosome c = new TestSuiteChromosome();
        StatementCoverageSuiteFitness f1 = new StatementCoverageSuiteFitness();
        OnlyBranchCoverageSuiteFitness f2 = new OnlyBranchCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f1);
        c.addFitness((FitnessFunction)f2);
        c.setFitness((FitnessFunction)f1, 2.0);
        c.setFitness((FitnessFunction)f2, 5.0);
        c.setCoverage((FitnessFunction)f1, 0.2);
        c.setCoverage((FitnessFunction)f2, 0.6);
        Assert.assertEquals((double)2.0, (double)c.getFitnessInstanceOf(StatementCoverageSuiteFitness.class), (double)0.001);
        Assert.assertEquals((double)5.0, (double)c.getFitnessInstanceOf(OnlyBranchCoverageSuiteFitness.class), (double)0.001);
        Assert.assertEquals((double)0.2, (double)c.getCoverageInstanceOf(StatementCoverageSuiteFitness.class), (double)0.001);
        Assert.assertEquals((double)0.6, (double)c.getCoverageInstanceOf(OnlyBranchCoverageSuiteFitness.class), (double)0.001);
        Assert.assertEquals((double)7.0, (double)c.getFitness(), (double)0.001);
        Assert.assertEquals((double)0.4, (double)c.getCoverage(), (double)0.001);
    }

    @Test
    public void testCompositionalGetFitnessForSeveralFunctions() {
        Properties.ALGORITHM = Properties.Algorithm.STEADYSTATEGA;
        Properties.COMPOSITIONAL_FITNESS = true;
        TestSuiteChromosome c = new TestSuiteChromosome();
        MethodTraceCoverageSuiteFitness f1 = new MethodTraceCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f1);
        c.setFitness((FitnessFunction)f1, 2.0);
        MethodNoExceptionCoverageSuiteFitness f2 = new MethodNoExceptionCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f2);
        c.setFitness((FitnessFunction)f2, 5.0);
        OutputCoverageSuiteFitness f3 = new OutputCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f3);
        c.setFitness((FitnessFunction)f3, 6.0);
        ExceptionCoverageSuiteFitness f4 = new ExceptionCoverageSuiteFitness();
        c.addFitness((FitnessFunction)f4);
        c.setFitness((FitnessFunction)f4, 3.0);
        double sum = 16.0;
        Assert.assertEquals((double)sum, (double)c.getFitness(), (double)0.001);
    }
}

