/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.variables.DoubleVariable;
import org.evosuite.ga.variables.Variable;
import org.evosuite.utils.Randomness;

public class NSGAChromosome
extends Chromosome {
    private static final long serialVersionUID = -2056801838518269049L;
    private List<Variable> variables = new ArrayList<Variable>();

    public NSGAChromosome() {
    }

    public NSGAChromosome(double lowerBound, double upperBound, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            DoubleVariable v = new DoubleVariable(values[i], lowerBound, upperBound);
            this.addVariable(v);
        }
    }

    public NSGAChromosome(boolean ZDT42, int number_of_variables, double lowerBound, double upperBound) {
        int index = 0;
        if (ZDT42) {
            DoubleVariable v = new DoubleVariable(0.0 + Randomness.nextDouble() * 1.0, 0.0, 1.0);
            this.addVariable(v);
            ++index;
        }
        for (int i = index; i < number_of_variables; ++i) {
            DoubleVariable v = new DoubleVariable(lowerBound + Randomness.nextDouble() * (upperBound - lowerBound), lowerBound, upperBound);
            this.addVariable(v);
        }
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Variable getVariable(int i) {
        return this.variables.get(i);
    }

    public int getNumberOfVariables() {
        return this.variables.size();
    }

    public void addVariable(Variable var) {
        this.variables.add(var);
    }

    public Chromosome clone() {
        NSGAChromosome c = new NSGAChromosome();
        c.setFitnesses(this.getFitnesses());
        c.setLastFitnesses(this.getLastFitnesses());
        for (Variable v : this.getVariables()) {
            c.addVariable(v.clone());
        }
        c.setSolution(this.isSolution());
        c.setChanged(this.isChanged());
        c.setCoverages(this.getCoverages());
        c.setNumsOfCoveredGoals(this.getNumsOfCoveredGoals());
        c.updateAge(this.getAge());
        c.setRank(this.getRank());
        c.setDistance(this.getDistance());
        return c;
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = hashCode * 37 + this.getVariables().hashCode();
        hashCode = hashCode * 37 + this.getFitnesses().hashCode();
        hashCode = hashCode * 37 + this.getLastFitnesses().hashCode();
        return hashCode;
    }

    public int compareSecondaryObjective(Chromosome o) {
        return 0;
    }

    public void mutate() {
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            Variable v = this.getVariable(i);
            if (!(v instanceof DoubleVariable)) continue;
            this.mutate((DoubleVariable)v);
        }
    }

    private void mutate(DoubleVariable v) {
        double deltaq;
        double ub = v.getUpperBound();
        double lb = v.getLowerBound();
        double db = ub - lb;
        double new_x = v.getValue();
        double delta1 = (new_x - lb) / db;
        double delta2 = (ub - new_x) / db;
        double distributionIndex = 10.0;
        double pow = 1.0 / (distributionIndex + 1.0);
        double r = Randomness.nextDouble();
        if (r < 0.5) {
            double aux = 2.0 * r + (1.0 - 2.0 * r) * Math.pow(1.0 - delta1, distributionIndex + 1.0);
            deltaq = Math.pow(aux, pow) - 1.0;
        } else {
            double aux = 2.0 * (1.0 - r) + 2.0 * (r - 0.5) * Math.pow(1.0 - delta2, distributionIndex + 1.0);
            deltaq = 1.0 - Math.pow(aux, pow);
        }
        new_x += deltaq * db;
        if (new_x < lb) {
            new_x = lb;
        } else if (new_x > ub) {
            new_x = ub;
        }
        v.setValue(new_x);
    }

    public void crossOver(Chromosome other, int position1, int position2) throws ConstructionFailedException {
    }

    public boolean localSearch(LocalSearchObjective<? extends Chromosome> objective) {
        return false;
    }

    public int size() {
        return 0;
    }
}

