/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.comparators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.comparators.DominanceComparator;
import org.evosuite.ga.problems.multiobjective.FON;
import org.evosuite.ga.problems.singleobjective.Booths;
import org.junit.Assert;
import org.junit.Test;

public class TestDominanceComparator {
    @Test
    public void testDominanceComparatorOneFitness() {
        Booths p = new Booths();
        List fitnessFunctions = p.getFitnessFunctions();
        FitnessFunction ff = fitnessFunctions.get(0);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setFitness(ff, 0.7);
        c2.setFitness(ff, 0.3);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        DominanceComparator dc = new DominanceComparator();
        Collections.sort(population, dc);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(0))).getFitness(ff), (double)0.3, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(1))).getFitness(ff), (double)0.7, (double)0.0);
    }

    @Test
    public void testDominanceComparatorSeveralFitnessesNoDomination() {
        FON p = new FON();
        List fitnessFunctions = p.getFitnessFunctions();
        FitnessFunction ff_1 = fitnessFunctions.get(0);
        FitnessFunction ff_2 = fitnessFunctions.get(1);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setFitness(ff_1, 0.7);
        c1.setFitness(ff_2, 0.2);
        c2.setFitness(ff_1, 0.3);
        c2.setFitness(ff_2, 0.5);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        DominanceComparator dc = new DominanceComparator();
        Collections.sort(population, dc);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(0))).getFitness(ff_1), (double)0.7, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(0))).getFitness(ff_2), (double)0.2, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(1))).getFitness(ff_1), (double)0.3, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(1))).getFitness(ff_2), (double)0.5, (double)0.0);
    }

    @Test
    public void testDominanceComparatorSeveralFitnessesDomination() {
        FON p = new FON();
        List fitnessFunctions = p.getFitnessFunctions();
        FitnessFunction ff_1 = fitnessFunctions.get(0);
        FitnessFunction ff_2 = fitnessFunctions.get(1);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setFitness(ff_1, 0.7);
        c1.setFitness(ff_2, 0.6);
        c2.setFitness(ff_1, 0.3);
        c2.setFitness(ff_2, 0.5);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        DominanceComparator dc = new DominanceComparator();
        Collections.sort(population, dc);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(0))).getFitness(ff_1), (double)0.3, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(0))).getFitness(ff_2), (double)0.5, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(1))).getFitness(ff_1), (double)0.7, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(1))).getFitness(ff_2), (double)0.6, (double)0.0);
    }
}

