/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.comparators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.comparators.SortByFitness;
import org.evosuite.ga.problems.singleobjective.Booths;
import org.junit.Assert;
import org.junit.Test;

public class TestSortByFitness {
    @Test
    public void testSortByFitnessC1win() {
        Booths p = new Booths();
        List fitnessFunctions = p.getFitnessFunctions();
        FitnessFunction ff = fitnessFunctions.get(0);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setFitness(ff, 0.7);
        c2.setFitness(ff, 0.3);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        SortByFitness sf = new SortByFitness(ff, true);
        Collections.sort(population, sf);
        Assert.assertTrue((population.get(0) == c1 ? 1 : 0) != 0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(0))).getFitness(ff), (double)0.7, (double)0.0);
        Assert.assertTrue((population.get(1) == c2 ? 1 : 0) != 0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(1))).getFitness(ff), (double)0.3, (double)0.0);
    }

    @Test
    public void testSortByFitnessC2win() {
        Booths p = new Booths();
        List fitnessFunctions = p.getFitnessFunctions();
        FitnessFunction ff = fitnessFunctions.get(0);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setFitness(ff, 0.3);
        c2.setFitness(ff, 0.7);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        SortByFitness sf = new SortByFitness(ff, true);
        Collections.sort(population, sf);
        Assert.assertTrue((population.get(0) == c2 ? 1 : 0) != 0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(0))).getFitness(ff), (double)0.7, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(1))).getFitness(ff), (double)0.3, (double)0.0);
        Assert.assertTrue((population.get(1) == c1 ? 1 : 0) != 0);
    }

    @Test
    public void testSortByFitnessEqual() {
        Booths p = new Booths();
        List fitnessFunctions = p.getFitnessFunctions();
        FitnessFunction ff = fitnessFunctions.get(0);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setFitness(ff, 0.5);
        c2.setFitness(ff, 0.5);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        SortByFitness sf = new SortByFitness(ff, true);
        Collections.sort(population, sf);
        Assert.assertTrue((population.get(0) == c1 ? 1 : 0) != 0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(0))).getFitness(ff), (double)0.5, (double)0.0);
        Assert.assertEquals((double)((NSGAChromosome)((Object)population.get(1))).getFitness(ff), (double)0.5, (double)0.0);
        Assert.assertTrue((population.get(1) == c2 ? 1 : 0) != 0);
    }
}

