/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import com.examples.with.different.packagename.Calculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.comparators.CrowdingComparator;
import org.evosuite.ga.comparators.SortByFitness;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.NSGAII;
import org.evosuite.ga.problems.multiobjective.SCH;
import org.evosuite.ga.problems.singleobjective.Booths;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNSGAII
extends SystemTest {
    @BeforeClass
    public static void setUp() {
        Properties.CROSSOVER_RATE = 0.9;
        Properties.RANDOM_SEED = 1L;
    }

    @Test
    public void testUnionEmptyPopulation() {
        NSGAII ga = new NSGAII(null);
        ArrayList pop = new ArrayList();
        ArrayList off = new ArrayList();
        List union = ga.union(pop, off);
        Assert.assertTrue((boolean)union.isEmpty());
    }

    @Test
    public void testUnion() {
        NSGAII ga = new NSGAII(null);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        NSGAChromosome c3 = new NSGAChromosome();
        ArrayList<NSGAChromosome> pop = new ArrayList<NSGAChromosome>();
        pop.add(c1);
        pop.add(c2);
        ArrayList<NSGAChromosome> off = new ArrayList<NSGAChromosome>();
        off.add(c3);
        List union = ga.union(pop, off);
        Assert.assertEquals((long)union.size(), (long)3L);
    }

    @Test
    public void testFastNonDominatedSort() {
        NSGAII ga = new NSGAII(null);
        Booths p = new Booths();
        List fitnessFunctions = p.getFitnessFunctions();
        ga.addFitnessFunctions(fitnessFunctions);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        NSGAChromosome c3 = new NSGAChromosome();
        NSGAChromosome c4 = new NSGAChromosome();
        NSGAChromosome c5 = new NSGAChromosome();
        NSGAChromosome c6 = new NSGAChromosome();
        NSGAChromosome c7 = new NSGAChromosome();
        NSGAChromosome c8 = new NSGAChromosome();
        NSGAChromosome c9 = new NSGAChromosome();
        NSGAChromosome c10 = new NSGAChromosome();
        c1.setFitness(fitnessFunctions.get(0), 0.6);
        c2.setFitness(fitnessFunctions.get(0), 0.2);
        c3.setFitness(fitnessFunctions.get(0), 0.4);
        c4.setFitness(fitnessFunctions.get(0), 0.0);
        c5.setFitness(fitnessFunctions.get(0), 0.8);
        c6.setFitness(fitnessFunctions.get(0), 0.8);
        c7.setFitness(fitnessFunctions.get(0), 0.2);
        c8.setFitness(fitnessFunctions.get(0), 0.4);
        c9.setFitness(fitnessFunctions.get(0), 0.6);
        c10.setFitness(fitnessFunctions.get(0), 0.0);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        population.add(c3);
        population.add(c4);
        population.add(c5);
        population.add(c6);
        population.add(c7);
        population.add(c8);
        population.add(c9);
        population.add(c10);
        List fronts = ga.fastNonDominatedSort(population);
        Assert.assertEquals((long)fronts.size(), (long)5L);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(0)).get(0))).getFitness() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(0)).get(1))).getFitness() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(1)).get(0))).getFitness() == 0.2 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(1)).get(1))).getFitness() == 0.2 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(2)).get(0))).getFitness() == 0.4 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(2)).get(1))).getFitness() == 0.4 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(3)).get(0))).getFitness() == 0.6 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(3)).get(1))).getFitness() == 0.6 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(4)).get(0))).getFitness() == 0.8 ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)((List)fronts.get(4)).get(1))).getFitness() == 0.8 ? 1 : 0) != 0);
    }

    @Test
    public void testCrowingDistanceAssignment_OneVariable() {
        NSGAII ga = new NSGAII(null);
        Booths p = new Booths();
        List fitnessFunctions = p.getFitnessFunctions();
        ga.addFitnessFunctions(fitnessFunctions);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        NSGAChromosome c3 = new NSGAChromosome();
        NSGAChromosome c4 = new NSGAChromosome();
        NSGAChromosome c5 = new NSGAChromosome();
        NSGAChromosome c6 = new NSGAChromosome();
        NSGAChromosome c7 = new NSGAChromosome();
        NSGAChromosome c8 = new NSGAChromosome();
        NSGAChromosome c9 = new NSGAChromosome();
        NSGAChromosome c10 = new NSGAChromosome();
        c1.setFitness(fitnessFunctions.get(0), 0.0);
        c2.setFitness(fitnessFunctions.get(0), 0.2);
        c3.setFitness(fitnessFunctions.get(0), 0.4);
        c4.setFitness(fitnessFunctions.get(0), 0.6);
        c5.setFitness(fitnessFunctions.get(0), 0.8);
        c6.setFitness(fitnessFunctions.get(0), 0.0);
        c7.setFitness(fitnessFunctions.get(0), 0.2);
        c8.setFitness(fitnessFunctions.get(0), 0.4);
        c9.setFitness(fitnessFunctions.get(0), 0.6);
        c10.setFitness(fitnessFunctions.get(0), 0.8);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        population.add(c3);
        population.add(c4);
        population.add(c5);
        population.add(c6);
        population.add(c7);
        population.add(c8);
        population.add(c9);
        population.add(c10);
        ga.crowingDistanceAssignment(population);
        Collections.sort(population, new CrowdingComparator(true));
        Assert.assertTrue((((NSGAChromosome)((Object)population.get(0))).getDistance() == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)population.get(1))).getDistance() == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
        double epsilon = 1.0E-10;
        Assert.assertTrue((Math.abs(0.25 - ((NSGAChromosome)((Object)population.get(2))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.25 - ((NSGAChromosome)((Object)population.get(3))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.25 - ((NSGAChromosome)((Object)population.get(4))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.25 - ((NSGAChromosome)((Object)population.get(5))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.25 - ((NSGAChromosome)((Object)population.get(6))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.25 - ((NSGAChromosome)((Object)population.get(7))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.25 - ((NSGAChromosome)((Object)population.get(8))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.25 - ((NSGAChromosome)((Object)population.get(9))).getDistance()) < epsilon ? 1 : 0) != 0);
    }

    @Test
    public void testCrowingDistanceAssignment_SeveralVariables() {
        NSGAII ga = new NSGAII(null);
        SCH p = new SCH();
        List fitnessFunctions = p.getFitnessFunctions();
        ga.addFitnessFunctions(fitnessFunctions);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        NSGAChromosome c3 = new NSGAChromosome();
        NSGAChromosome c4 = new NSGAChromosome();
        NSGAChromosome c5 = new NSGAChromosome();
        NSGAChromosome c6 = new NSGAChromosome();
        NSGAChromosome c7 = new NSGAChromosome();
        NSGAChromosome c8 = new NSGAChromosome();
        NSGAChromosome c9 = new NSGAChromosome();
        NSGAChromosome c10 = new NSGAChromosome();
        c1.setFitness(fitnessFunctions.get(0), 0.0);
        c2.setFitness(fitnessFunctions.get(0), 0.2);
        c3.setFitness(fitnessFunctions.get(0), 0.4);
        c4.setFitness(fitnessFunctions.get(0), 0.6);
        c5.setFitness(fitnessFunctions.get(0), 0.8);
        c6.setFitness(fitnessFunctions.get(0), 0.0);
        c7.setFitness(fitnessFunctions.get(0), 0.2);
        c8.setFitness(fitnessFunctions.get(0), 0.4);
        c9.setFitness(fitnessFunctions.get(0), 0.6);
        c10.setFitness(fitnessFunctions.get(0), 0.8);
        c1.setFitness(fitnessFunctions.get(1), 0.1);
        c2.setFitness(fitnessFunctions.get(1), 0.3);
        c3.setFitness(fitnessFunctions.get(1), 0.5);
        c4.setFitness(fitnessFunctions.get(1), 0.7);
        c5.setFitness(fitnessFunctions.get(1), 0.9);
        c6.setFitness(fitnessFunctions.get(1), 0.1);
        c7.setFitness(fitnessFunctions.get(1), 0.3);
        c8.setFitness(fitnessFunctions.get(1), 0.5);
        c9.setFitness(fitnessFunctions.get(1), 0.7);
        c10.setFitness(fitnessFunctions.get(1), 0.9);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        population.add(c3);
        population.add(c4);
        population.add(c5);
        population.add(c6);
        population.add(c7);
        population.add(c8);
        population.add(c9);
        population.add(c10);
        ga.crowingDistanceAssignment(population);
        Collections.sort(population, new CrowdingComparator(true));
        Assert.assertTrue((((NSGAChromosome)((Object)population.get(0))).getDistance() == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
        Assert.assertTrue((((NSGAChromosome)((Object)population.get(1))).getDistance() == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
        double epsilon = 1.0E-10;
        Assert.assertTrue((Math.abs(0.5 - ((NSGAChromosome)((Object)population.get(2))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.5 - ((NSGAChromosome)((Object)population.get(3))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.5 - ((NSGAChromosome)((Object)population.get(4))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.5 - ((NSGAChromosome)((Object)population.get(5))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.5 - ((NSGAChromosome)((Object)population.get(6))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.5 - ((NSGAChromosome)((Object)population.get(7))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.5 - ((NSGAChromosome)((Object)population.get(8))).getDistance()) < epsilon ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(0.5 - ((NSGAChromosome)((Object)population.get(9))).getDistance()) < epsilon ? 1 : 0) != 0);
    }

    @Test
    public void testIntegration() {
        String targetClass;
        Properties.MUTATION_RATE = 1.0;
        Properties.CRITERION = new Properties.Criterion[2];
        Properties.CRITERION[0] = Properties.Criterion.RHO;
        Properties.CRITERION[1] = Properties.Criterion.AMBIGUITY;
        Properties.ALGORITHM = Properties.Algorithm.NSGAII;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = Calculator.class.getCanonicalName();
        String[] command = new String[]{"-Dselection_function=BINARY_TOURNAMENT", "-Dminimize_values=false", "-Dinline=false", "-Dminimize=true", "-Dstop_zero=false", "-Dcoverage=true", "-Djunit_tests=true", "-Dassertions=true", "-Dsandbox=true", "-Dnew_statistics=false", "-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        Assert.assertNotNull((Object)result);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        FitnessFunction rho = (FitnessFunction)ga.getFitnessFunctions().get(0);
        FitnessFunction ag = (FitnessFunction)ga.getFitnessFunctions().get(1);
        ArrayList population = new ArrayList(ga.getBestIndividuals());
        Collections.sort(population, new SortByFitness(rho, false));
        for (Chromosome p : population) {
            System.out.println("Rho: " + p.getFitness(rho) + ", AG: " + p.getFitness(ag) + " | Rank: " + p.getRank());
            Assert.assertEquals((double)0.0, (double)p.getFitness(rho), (double)0.0);
            Assert.assertEquals((double)0.0, (double)p.getFitness(ag), (double)0.0);
            Assert.assertEquals((long)0L, (long)p.getRank());
        }
    }
}

