/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.crossover;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.ga.variables.DoubleVariable;
import org.evosuite.ga.variables.Variable;
import org.evosuite.utils.Randomness;

public class SBXCrossover<T extends NSGAChromosome>
extends CrossOverFunction {
    private static final long serialVersionUID = -4258729002155733390L;
    private static final double EPS = 1.0E-10;

    public void crossOver(Chromosome p1, Chromosome p2) throws ConstructionFailedException {
        NSGAChromosome n1 = (NSGAChromosome)p1;
        NSGAChromosome n2 = (NSGAChromosome)p2;
        for (int i = 0; i < n1.getNumberOfVariables(); ++i) {
            Variable v1 = n1.getVariable(i);
            Variable v2 = n2.getVariable(i);
            if (!(v1 instanceof DoubleVariable) || !(v2 instanceof DoubleVariable)) continue;
            this.doCrossover((DoubleVariable)v1, (DoubleVariable)v2);
        }
    }

    private void doCrossover(DoubleVariable v1, DoubleVariable v2) {
        double valueX2;
        double distributionIndex = 20.0;
        double yL = v1.getLowerBound();
        double yu = v1.getUpperBound();
        double valueX1 = v1.getValue();
        if (Math.abs(valueX1 - (valueX2 = v2.getValue())) > 1.0E-10) {
            double y2;
            double y1;
            if (valueX1 < valueX2) {
                y1 = valueX1;
                y2 = valueX2;
            } else {
                y1 = valueX2;
                y2 = valueX1;
            }
            double rand = Randomness.nextDouble();
            double beta = 1.0 + 2.0 * (y1 - yL) / (y2 - y1);
            double alpha = 2.0 - Math.pow(beta, -(distributionIndex + 1.0));
            double betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (distributionIndex + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (distributionIndex + 1.0));
            double c1 = 0.5 * (y1 + y2 - betaq * (y2 - y1));
            beta = 1.0 + 2.0 * (yu - y2) / (y2 - y1);
            alpha = 2.0 - Math.pow(beta, -(distributionIndex + 1.0));
            betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (distributionIndex + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (distributionIndex + 1.0));
            double c2 = 0.5 * (y1 + y2 + betaq * (y2 - y1));
            if (c1 < yL) {
                c1 = yL;
            }
            if (c2 < yL) {
                c2 = yL;
            }
            if (c1 > yu) {
                c1 = yu;
            }
            if (c2 > yu) {
                c2 = yu;
            }
            if (Randomness.nextDouble() <= 0.5) {
                valueX1 = c2;
                valueX2 = c1;
            } else {
                valueX1 = c1;
                valueX2 = c2;
            }
            v1.setValue(valueX1);
            v2.setValue(valueX2);
        }
    }
}

