/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.selection;

import java.util.ArrayList;
import org.evosuite.Properties;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.metaheuristics.NSGAII;
import org.evosuite.ga.operators.selection.BinaryTournamentSelectionCrowdedComparison;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBinaryTournamentSelectionCrowdedComparison {
    @BeforeClass
    public static void setUp() {
        Properties.RANDOM_SEED = 1L;
    }

    @Test
    public void testNonDominationRankMinimize() {
        NSGAII ga = new NSGAII(null);
        BinaryTournamentSelectionCrowdedComparison ts = new BinaryTournamentSelectionCrowdedComparison(false);
        ts.setMaximize(false);
        ga.setSelectionFunction((SelectionFunction)ts);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setRank(1);
        c2.setRank(0);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        Assert.assertTrue((ts.getIndex(population) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNonDominationRankMaximize() {
        NSGAII ga = new NSGAII(null);
        BinaryTournamentSelectionCrowdedComparison ts = new BinaryTournamentSelectionCrowdedComparison(true);
        ts.setMaximize(true);
        ga.setSelectionFunction((SelectionFunction)ts);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setRank(1);
        c2.setRank(0);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        Assert.assertTrue((ts.getIndex(population) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCrowdingDistanceMinimize() {
        NSGAII ga = new NSGAII(null);
        BinaryTournamentSelectionCrowdedComparison ts = new BinaryTournamentSelectionCrowdedComparison(false);
        ts.setMaximize(false);
        ga.setSelectionFunction((SelectionFunction)ts);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setRank(0);
        c2.setRank(0);
        c1.setDistance(0.1);
        c2.setDistance(0.5);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        Assert.assertTrue((ts.getIndex(population) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCrowdingDistanceMaximize() {
        NSGAII ga = new NSGAII(null);
        BinaryTournamentSelectionCrowdedComparison ts = new BinaryTournamentSelectionCrowdedComparison(true);
        ts.setMaximize(true);
        ga.setSelectionFunction((SelectionFunction)ts);
        NSGAChromosome c1 = new NSGAChromosome();
        NSGAChromosome c2 = new NSGAChromosome();
        c1.setRank(0);
        c2.setRank(0);
        c1.setDistance(0.1);
        c2.setDistance(0.5);
        ArrayList<NSGAChromosome> population = new ArrayList<NSGAChromosome>();
        population.add(c1);
        population.add(c2);
        Assert.assertTrue((ts.getIndex(population) == 1 ? 1 : 0) != 0);
    }
}

