/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.selection;

import java.util.LinkedList;
import org.evosuite.ga.operators.selection.FitnessProportionateSelection;
import org.evosuite.ga.operators.selection.RankSelection;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.operators.selection.TournamentSelection;
import org.evosuite.testcase.TestChromosome;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestSelectionOperators {
    @Test
    public void testMaximizeVariable() {
        SelectionFunction[] v;
        for (SelectionFunction sf : v = new SelectionFunction[]{new TournamentSelection(), new FitnessProportionateSelection(), new RankSelection()}) {
            sf.setMaximize(true);
            Assert.assertTrue((boolean)sf.isMaximize());
            sf.setMaximize(false);
            Assert.assertTrue((!sf.isMaximize() ? 1 : 0) != 0);
        }
    }

    @Ignore
    @Test
    public void testProportions() {
        boolean[] maximize = new boolean[]{false, true};
        SelectionFunction[] v = new SelectionFunction[]{new TournamentSelection(), new FitnessProportionateSelection(), new RankSelection()};
        int N = 10;
        for (boolean b : maximize) {
            LinkedList<TestChromosome> population = new LinkedList<TestChromosome>();
            for (int i = 0; i < 10; ++i) {
                TestChromosome ind = new TestChromosome();
                double fit = b ? (double)(10 - i) : (double)i;
                ind.addFitness(null, fit);
                population.add(ind);
            }
            for (SelectionFunction sf : v) {
                int j;
                sf.setMaximize(b);
                int[] counter = new int[10];
                for (j = 0; j < 10000; ++j) {
                    int index;
                    int n = index = sf.getIndex(population);
                    counter[n] = counter[n] + 1;
                }
                for (j = 0; j < 9; ++j) {
                    Assert.assertTrue((String)("" + counter[j] + " " + counter[j + 1]), (counter[j] > counter[j + 1] ? 1 : 0) != 0);
                }
                Assert.assertTrue((counter[9] > 0 ? 1 : 0) != 0);
            }
        }
    }
}

