/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.metrics;

import org.evosuite.ga.problems.metrics.Metrics;

public class GenerationalDistance
extends Metrics {
    private static int P = 2;
    private static int NUMBER_FITNESSES = 2;

    private double[] getMaximumValues(double[][] front) {
        double[] maximumValue = new double[NUMBER_FITNESSES];
        for (int i = 0; i < NUMBER_FITNESSES; ++i) {
            maximumValue[i] = Double.NEGATIVE_INFINITY;
        }
        for (double[] aFront : front) {
            for (int j = 0; j < aFront.length; ++j) {
                if (!(aFront[j] > maximumValue[j])) continue;
                maximumValue[j] = aFront[j];
            }
        }
        return maximumValue;
    }

    private double[] getMinimumValues(double[][] front) {
        double[] minimumValue = new double[NUMBER_FITNESSES];
        for (int i = 0; i < NUMBER_FITNESSES; ++i) {
            minimumValue[i] = Double.MAX_VALUE;
        }
        for (double[] aFront : front) {
            for (int j = 0; j < aFront.length; ++j) {
                if (!(aFront[j] < minimumValue[j])) continue;
                minimumValue[j] = aFront[j];
            }
        }
        return minimumValue;
    }

    private double[][] getNormalizedFront(double[][] front, double[] maximumValue, double[] minimumValue) {
        double[][] normalizedFront = new double[front.length][];
        for (int i = 0; i < front.length; ++i) {
            normalizedFront[i] = new double[front[i].length];
            for (int j = 0; j < front[i].length; ++j) {
                normalizedFront[i][j] = (front[i][j] - minimumValue[j]) / (maximumValue[j] - minimumValue[j]);
            }
        }
        return normalizedFront;
    }

    private double distanceToClosedPoint(double[] point, double[][] front) {
        double minDistance = this.euclideanDistance(point, front[0]);
        for (int i = 1; i < front.length; ++i) {
            double aux = this.euclideanDistance(point, front[i]);
            if (!(aux < minDistance)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public double evaluate(double[][] front, double[][] trueParetoFront) {
        double[] maximumValue = this.getMaximumValues(trueParetoFront);
        double[] minimumValue = this.getMinimumValues(trueParetoFront);
        double[][] normalizedFront = this.getNormalizedFront(front, maximumValue, minimumValue);
        double[][] normalizedParetoFront = this.getNormalizedFront(trueParetoFront, maximumValue, minimumValue);
        double sum = 0.0;
        for (int i = 0; i < front.length; ++i) {
            sum += Math.pow(this.distanceToClosedPoint(normalizedFront[i], normalizedParetoFront), P);
        }
        sum = Math.pow(sum, 1.0 / (double)P);
        double generationalDistance = sum / (double)normalizedFront.length;
        return generationalDistance;
    }
}

