/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.multiobjective;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.problems.Problem;
import org.evosuite.ga.variables.DoubleVariable;

public class FON<T extends NSGAChromosome>
implements Problem {
    private List<FitnessFunction<T>> fitnessFunctions = new ArrayList<FitnessFunction<T>>();

    public FON() {
        class F1FitnessFunction
        extends FitnessFunction {
            F1FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                double fitness = 0.0;
                for (int i = 0; i < individual.getNumberOfVariables(); ++i) {
                    DoubleVariable dv = (DoubleVariable)individual.getVariables().get(i);
                    fitness += Math.pow(dv.getValue() - 1.0 / Math.sqrt(3.0), 2.0);
                }
                fitness = 1.0 - Math.exp(-fitness);
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F1FitnessFunction());
        class F2FitnessFunction
        extends FitnessFunction {
            F2FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                double fitness = 0.0;
                for (int i = 0; i < individual.getNumberOfVariables(); ++i) {
                    DoubleVariable dv = (DoubleVariable)individual.getVariables().get(i);
                    fitness += Math.pow(dv.getValue() + 1.0 / Math.sqrt(3.0), 2.0);
                }
                fitness = 1.0 - Math.exp(-fitness);
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F2FitnessFunction());
    }

    @Override
    public List<FitnessFunction<T>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }
}

