/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.multiobjective;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.problems.Problem;
import org.evosuite.ga.variables.DoubleVariable;

public class POL<T extends NSGAChromosome>
implements Problem {
    private List<FitnessFunction<T>> fitnessFunctions = new ArrayList<FitnessFunction<T>>();

    public POL() {
        class F1FitnessFunction
        extends FitnessFunction {
            F1FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                double x1 = ((DoubleVariable)individual.getVariable(0)).getValue();
                double x2 = ((DoubleVariable)individual.getVariable(1)).getValue();
                double A1 = 0.5 * Math.sin(1.0) - 2.0 * Math.cos(1.0) + Math.sin(2.0) - 1.5 * Math.cos(2.0);
                double A2 = 1.5 * Math.sin(1.0) - Math.cos(1.0) + 2.0 * Math.sin(2.0) - 0.5 * Math.cos(2.0);
                double B1 = 0.5 * Math.sin(x1) - 2.0 * Math.cos(x1) + Math.sin(x2) - 1.5 * Math.cos(x2);
                double B2 = 1.5 * Math.sin(x1) - Math.cos(x1) + 2.0 * Math.sin(x2) - 0.5 * Math.cos(x2);
                double fitness = 1.0 + Math.pow(A1 - B1, 2.0) + Math.pow(A2 - B2, 2.0);
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F1FitnessFunction());
        class F2FitnessFunction
        extends FitnessFunction {
            F2FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                double x1 = ((DoubleVariable)individual.getVariable(0)).getValue();
                double x2 = ((DoubleVariable)individual.getVariable(1)).getValue();
                double fitness = Math.pow(x1 + 3.0, 2.0) + Math.pow(x2 + 1.0, 2.0);
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F2FitnessFunction());
    }

    @Override
    public List<FitnessFunction<T>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }
}

