/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.multiobjective;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.problems.Problem;
import org.evosuite.ga.variables.DoubleVariable;

public class SCH<T extends NSGAChromosome>
implements Problem {
    private List<FitnessFunction<T>> fitnessFunctions = new ArrayList<FitnessFunction<T>>();

    public SCH() {
        class F1FitnessFunction
        extends FitnessFunction {
            F1FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                DoubleVariable dv = (DoubleVariable)individual.getVariables().get(0);
                double x = dv.getValue();
                double fitness = x * x;
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F1FitnessFunction());
        class F2FitnessFunction
        extends FitnessFunction {
            F2FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                DoubleVariable dv = (DoubleVariable)individual.getVariables().get(0);
                double x = dv.getValue();
                double fitness = (x - 2.0) * (x - 2.0);
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F2FitnessFunction());
    }

    @Override
    public List<FitnessFunction<T>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }
}

