/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.multiobjective;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.metaheuristics.NSGAII;
import org.evosuite.ga.metaheuristics.RandomFactory;
import org.evosuite.ga.operators.crossover.SBXCrossover;
import org.evosuite.ga.operators.selection.BinaryTournamentSelectionCrowdedComparison;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.problems.metrics.GenerationalDistance;
import org.evosuite.ga.problems.metrics.Metrics;
import org.evosuite.ga.problems.metrics.Spacing;
import org.evosuite.ga.problems.multiobjective.SCH;
import org.evosuite.ga.variables.DoubleVariable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSCH {
    @Before
    public void setUp() {
        Properties.POPULATION = 100;
        Properties.SEARCH_BUDGET = 10000L;
        Properties.CROSSOVER_RATE = 0.9;
        Properties.RANDOM_SEED = 1L;
    }

    @Test
    public void testSCHFitnesses() {
        SCH p = new SCH();
        FitnessFunction f1 = p.getFitnessFunctions().get(0);
        FitnessFunction f2 = p.getFitnessFunctions().get(1);
        double[] values_n = new double[]{-10.0};
        NSGAChromosome c = new NSGAChromosome(Math.pow(-10.0, 3.0), Math.pow(10.0, 3.0), values_n);
        Assert.assertEquals((double)((DoubleVariable)c.getVariables().get(0)).getValue(), (double)-10.0, (double)0.0);
        Assert.assertEquals((double)f1.getFitness((Chromosome)c), (double)100.0, (double)0.0);
        Assert.assertEquals((double)f2.getFitness((Chromosome)c), (double)144.0, (double)0.0);
        double[] values_z = new double[]{0.0};
        c = new NSGAChromosome(Math.pow(-10.0, 3.0), Math.pow(10.0, 3.0), values_z);
        Assert.assertEquals((double)((DoubleVariable)c.getVariables().get(0)).getValue(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)f1.getFitness((Chromosome)c), (double)0.0, (double)0.0);
        Assert.assertEquals((double)f2.getFitness((Chromosome)c), (double)4.0, (double)0.0);
        double[] values_p = new double[]{10.0};
        c = new NSGAChromosome(Math.pow(-10.0, 3.0), Math.pow(10.0, 3.0), values_p);
        Assert.assertEquals((double)((DoubleVariable)c.getVariables().get(0)).getValue(), (double)10.0, (double)0.0);
        Assert.assertEquals((double)f1.getFitness((Chromosome)c), (double)100.0, (double)0.0);
        Assert.assertEquals((double)f2.getFitness((Chromosome)c), (double)64.0, (double)0.0);
    }

    @Test
    public void testSCH() throws NumberFormatException, IOException {
        Properties.MUTATION_RATE = 1.0;
        RandomFactory factory = new RandomFactory(false, 1, Math.pow(-10.0, 3.0), Math.pow(10.0, 3.0));
        NSGAII ga = new NSGAII((ChromosomeFactory)factory);
        BinaryTournamentSelectionCrowdedComparison ts = new BinaryTournamentSelectionCrowdedComparison();
        ts.setMaximize(false);
        ga.setSelectionFunction((SelectionFunction)ts);
        ga.setCrossOverFunction(new SBXCrossover());
        SCH p = new SCH();
        final FitnessFunction f1 = p.getFitnessFunctions().get(0);
        FitnessFunction f2 = p.getFitnessFunctions().get(1);
        ga.addFitnessFunction(f1);
        ga.addFitnessFunction(f2);
        ga.generateSolution();
        List chromosomes = ga.getPopulation();
        Collections.sort(chromosomes, new Comparator<Chromosome>(){

            @Override
            public int compare(Chromosome arg0, Chromosome arg1) {
                return Double.compare(arg0.getFitness(f1), arg1.getFitness(f1));
            }
        });
        double[][] front = new double[Properties.POPULATION][2];
        int index = 0;
        for (Chromosome chromosome : chromosomes) {
            System.out.printf("%f,%f\n", chromosome.getFitness(f1), chromosome.getFitness(f2));
            front[index][0] = chromosome.getFitness(f1);
            front[index][1] = chromosome.getFitness(f2);
            ++index;
        }
        double[][] trueParetoFront = Metrics.readFront("Schaffer.pf");
        GenerationalDistance gd = new GenerationalDistance();
        double gdd = gd.evaluate(front, trueParetoFront);
        System.out.println("GenerationalDistance: " + gdd);
        Assert.assertEquals((double)gdd, (double)6.0E-4, (double)1.0E-4);
        Spacing sp = new Spacing();
        double spd = sp.evaluate(front);
        double spdt = sp.evaluate(trueParetoFront);
        System.out.println("SpacingFront (" + spd + ") - SpacingTrueFront (" + spdt + ") = " + Math.abs(spd - spdt));
        Assert.assertEquals((double)Math.abs(spd - spdt), (double)1.15, (double)0.05);
    }
}

