/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.multiobjective;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.metaheuristics.NSGAII;
import org.evosuite.ga.metaheuristics.RandomFactory;
import org.evosuite.ga.operators.crossover.SBXCrossover;
import org.evosuite.ga.operators.selection.BinaryTournamentSelectionCrowdedComparison;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.problems.metrics.GenerationalDistance;
import org.evosuite.ga.problems.metrics.Metrics;
import org.evosuite.ga.problems.metrics.Spacing;
import org.evosuite.ga.problems.multiobjective.ZDT6;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZDT6 {
    @Before
    public void setUp() {
        Properties.POPULATION = 100;
        Properties.SEARCH_BUDGET = 50000L;
        Properties.CROSSOVER_RATE = 0.9;
        Properties.RANDOM_SEED = 1L;
    }

    @Test
    public void testZDT6Fitnesses() {
        ZDT6 p = new ZDT6();
        FitnessFunction f1 = p.getFitnessFunctions().get(0);
        FitnessFunction f2 = p.getFitnessFunctions().get(1);
        double[] values = new double[]{0.541, 0.585, 0.915, 0.624, 0.493, 0.142, 0.971, 0.836, 0.763, 0.323};
        NSGAChromosome c = new NSGAChromosome(0.0, 1.0, values);
        Assert.assertEquals((double)f1.getFitness((Chromosome)c), (double)0.9866973935066625, (double)0.0);
        Assert.assertEquals((double)f2.getFitness((Chromosome)c), (double)8.903810335418541, (double)0.0);
    }

    @Test
    public void testZDT6() throws NumberFormatException, IOException {
        Properties.MUTATION_RATE = 0.1;
        RandomFactory factory = new RandomFactory(false, 10, 0.0, 1.0);
        NSGAII ga = new NSGAII((ChromosomeFactory)factory);
        BinaryTournamentSelectionCrowdedComparison ts = new BinaryTournamentSelectionCrowdedComparison();
        ts.setMaximize(false);
        ga.setSelectionFunction((SelectionFunction)ts);
        ga.setCrossOverFunction(new SBXCrossover());
        ZDT6 p = new ZDT6();
        final FitnessFunction f1 = p.getFitnessFunctions().get(0);
        FitnessFunction f2 = p.getFitnessFunctions().get(1);
        ga.addFitnessFunction(f1);
        ga.addFitnessFunction(f2);
        ga.generateSolution();
        List chromosomes = ga.getPopulation();
        Collections.sort(chromosomes, new Comparator<Chromosome>(){

            @Override
            public int compare(Chromosome arg0, Chromosome arg1) {
                return Double.compare(arg0.getFitness(f1), arg1.getFitness(f1));
            }
        });
        double[][] front = new double[Properties.POPULATION][2];
        int index = 0;
        for (Chromosome chromosome : chromosomes) {
            System.out.printf("%f,%f\n", chromosome.getFitness(f1), chromosome.getFitness(f2));
            front[index][0] = chromosome.getFitness(f1);
            front[index][1] = chromosome.getFitness(f2);
            ++index;
        }
        double[][] trueParetoFront = Metrics.readFront("ZDT6.pf");
        GenerationalDistance gd = new GenerationalDistance();
        double gdd = gd.evaluate(front, trueParetoFront);
        System.out.println("GenerationalDistance: " + gdd);
        Assert.assertEquals((double)gdd, (double)5.0E-4, (double)5.0E-4);
        Spacing sp = new Spacing();
        double spd = sp.evaluate(front);
        double spdt = sp.evaluate(trueParetoFront);
        System.out.println("SpacingFront (" + spd + ") - SpacingTrueFront (" + spdt + ") = " + Math.abs(spd - spdt));
        Assert.assertEquals((double)Math.abs(spd - spdt), (double)0.15, (double)0.05);
    }
}

