/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.multiobjective;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.problems.Problem;
import org.evosuite.ga.variables.DoubleVariable;

public class ZDT4<T extends NSGAChromosome>
implements Problem {
    private List<FitnessFunction<T>> fitnessFunctions = new ArrayList<FitnessFunction<T>>();

    public ZDT4() {
        class F1FitnessFunction
        extends FitnessFunction {
            F1FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                double fitness = ((DoubleVariable)individual.getVariable(0)).getValue();
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F1FitnessFunction());
        class F2FitnessFunction
        extends FitnessFunction {
            F2FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                double g = 0.0;
                for (int i = 1; i < individual.getNumberOfVariables(); ++i) {
                    DoubleVariable dv = (DoubleVariable)individual.getVariable(i);
                    g += Math.pow(dv.getValue(), 2.0) - 10.0 * Math.cos(Math.PI * 4 * dv.getValue() / 180.0);
                }
                double h = 1.0 - Math.sqrt(((DoubleVariable)individual.getVariable(0)).getValue() / (g += 1.0 + 10.0 * (double)(individual.getNumberOfVariables() - 1)));
                double fitness = g * h;
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F2FitnessFunction());
    }

    @Override
    public List<FitnessFunction<T>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }
}

