/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.multiobjective;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.problems.Problem;
import org.evosuite.ga.variables.DoubleVariable;

public class ZDT6<T extends NSGAChromosome>
implements Problem {
    private List<FitnessFunction<T>> fitnessFunctions = new ArrayList<FitnessFunction<T>>();

    public ZDT6() {
        class F1FitnessFunction
        extends FitnessFunction {
            F1FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                double x = ((DoubleVariable)individual.getVariable(0)).getValue();
                double fitness = 1.0 - Math.exp(-4.0 * x) * Math.pow(Math.sin(Math.PI * 6 * x), 6.0);
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F1FitnessFunction());
        class F2FitnessFunction
        extends FitnessFunction {
            F2FitnessFunction() {
            }

            public double getFitness(Chromosome c) {
                NSGAChromosome individual = (NSGAChromosome)c;
                double x = ((DoubleVariable)individual.getVariable(0)).getValue();
                double f1 = 1.0 - Math.exp(-4.0 * x) * Math.pow(Math.sin(Math.PI * 6 * x), 6.0);
                double sum = 0.0;
                for (int i = 1; i < individual.getNumberOfVariables(); ++i) {
                    double dv = ((DoubleVariable)individual.getVariable(i)).getValue();
                    sum += dv;
                }
                double g = 1.0 + 9.0 * Math.pow(sum / ((double)individual.getNumberOfVariables() - 1.0), 0.25);
                double h = 1.0 - Math.pow(f1 / g, 2.0);
                double fitness = g * h;
                this.updateIndividual(this, individual, fitness);
                return fitness;
            }

            public boolean isMaximizationFunction() {
                return false;
            }
        }
        this.fitnessFunctions.add(new F2FitnessFunction());
    }

    @Override
    public List<FitnessFunction<T>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }
}

