/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.problems.singleobjective;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.NSGAChromosome;
import org.evosuite.ga.metaheuristics.NSGAII;
import org.evosuite.ga.metaheuristics.RandomFactory;
import org.evosuite.ga.operators.crossover.SBXCrossover;
import org.evosuite.ga.operators.selection.BinaryTournamentSelectionCrowdedComparison;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.problems.singleobjective.Sphere;
import org.evosuite.ga.variables.DoubleVariable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestShere {
    @BeforeClass
    public static void setUp() {
        Properties.POPULATION = 100;
        Properties.SEARCH_BUDGET = 2500L;
        Properties.CROSSOVER_RATE = 0.9;
        Properties.RANDOM_SEED = 1L;
    }

    @Test
    public void testSphereFitness() {
        Sphere p = new Sphere();
        FitnessFunction f1 = p.getFitnessFunctions().get(0);
        double[] values = new double[]{-2.0};
        NSGAChromosome c = new NSGAChromosome(Math.pow(-10.0, 3.0), Math.pow(10.0, 3.0), values);
        Assert.assertEquals((double)((DoubleVariable)c.getVariables().get(0)).getValue(), (double)-2.0, (double)0.0);
        Assert.assertEquals((double)f1.getFitness((Chromosome)c), (double)4.0, (double)0.0);
    }

    @Test
    public void testSphere() throws NumberFormatException, IOException {
        Properties.MUTATION_RATE = 1.0;
        RandomFactory factory = new RandomFactory(false, 1, Math.pow(-10.0, 3.0), Math.pow(10.0, 3.0));
        NSGAII ga = new NSGAII((ChromosomeFactory)factory);
        BinaryTournamentSelectionCrowdedComparison ts = new BinaryTournamentSelectionCrowdedComparison();
        ga.setSelectionFunction((SelectionFunction)ts);
        ga.setCrossOverFunction(new SBXCrossover());
        Sphere p = new Sphere();
        final FitnessFunction f1 = p.getFitnessFunctions().get(0);
        ga.addFitnessFunction(f1);
        ga.generateSolution();
        List chromosomes = ga.getPopulation();
        Collections.sort(chromosomes, new Comparator<Chromosome>(){

            @Override
            public int compare(Chromosome arg0, Chromosome arg1) {
                return Double.compare(arg0.getFitness(f1), arg1.getFitness(f1));
            }
        });
        for (Chromosome chromosome : chromosomes) {
            Assert.assertEquals((double)chromosome.getFitness(f1), (double)0.0, (double)0.01);
        }
        for (Chromosome chromosome : chromosomes) {
            NSGAChromosome nsga_c = (NSGAChromosome)chromosome;
            DoubleVariable x = (DoubleVariable)nsga_c.getVariables().get(0);
            System.out.printf("%f : %f\n", x.getValue(), chromosome.getFitness(f1));
        }
    }
}

