/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.variables;

import java.text.MessageFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.evosuite.ga.variables.Variable;

public class DoubleVariable
implements Variable {
    private static final String VALUE_OUT_OF_BOUNDS = "value out of bounds (value: {0}, min: {1}, max: {2})";
    private double value;
    private final double lowerBound;
    private final double upperBound;

    public DoubleVariable(double lowerBound, double upperBound) {
        this(Double.NaN, lowerBound, upperBound);
    }

    public DoubleVariable(double value, double lowerBound, double upperBound) {
        this.value = value;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (value < lowerBound || value > upperBound) {
            throw new IllegalArgumentException(MessageFormat.format(VALUE_OUT_OF_BOUNDS, value, lowerBound, upperBound));
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (value < this.lowerBound || value > this.upperBound) {
            throw new IllegalArgumentException(MessageFormat.format(VALUE_OUT_OF_BOUNDS, value, this.lowerBound, this.upperBound));
        }
        this.value = value;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    @Override
    public DoubleVariable clone() {
        return new DoubleVariable(this.value, this.lowerBound, this.upperBound);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.lowerBound).append(this.upperBound).append(this.value).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DoubleVariable rhs = (DoubleVariable)obj;
        return new EqualsBuilder().append(this.lowerBound, rhs.lowerBound).append(this.upperBound, rhs.upperBound).append(this.value, rhs.value).isEquals();
    }
}

