/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import com.examples.with.different.packagename.errorbranch.DoubleDivisionByZero;
import com.examples.with.different.packagename.errorbranch.FloatDivisionByZero;
import com.examples.with.different.packagename.errorbranch.IntDivisionByZero;
import com.examples.with.different.packagename.errorbranch.LongDivisionByZero;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.Assert;
import org.junit.Test;

public class TestDivisionByZeroInstrumentation
extends SystemTest {
    @Test
    public void testIntDivisionWithoutErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = IntDivisionByZero.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)2L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testIntDivisionWithErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = IntDivisionByZero.class.getCanonicalName();
        Properties.ERROR_BRANCHES = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertTrue((String)("Wrong number of goals: " + goals), (goals > 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)0.8333333333333334, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testFloatDivisionWithErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = FloatDivisionByZero.class.getCanonicalName();
        Properties.ERROR_BRANCHES = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertTrue((String)("Wrong number of goals: " + goals), (goals > 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)0.8333333333333334, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testDoubleDivisionWithErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DoubleDivisionByZero.class.getCanonicalName();
        Properties.ERROR_BRANCHES = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertTrue((String)("Wrong number of goals: " + goals), (goals > 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)0.8333333333333334, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testLongDivisionWithErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = LongDivisionByZero.class.getCanonicalName();
        Properties.ERROR_BRANCHES = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertTrue((String)("Wrong number of goals: " + goals), (goals > 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)0.8333333333333334, (double)best.getCoverage(), (double)0.001);
    }
}

