/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import com.examples.with.different.packagename.errorbranch.LinkedListAccess;
import com.examples.with.different.packagename.errorbranch.LinkedListAccessIndex;
import java.util.List;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.Assert;
import org.junit.Test;

public class TestLinkedListInstrumentation
extends SystemTest {
    @Test
    public void testLinkedListWithoutErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = LinkedListAccess.class.getCanonicalName();
        Properties.ERROR_BRANCHES = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)3L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testLinkedListWithErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = LinkedListAccess.class.getCanonicalName();
        Properties.ERROR_BRANCHES = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        List goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)13L, (long)goals.size());
        TestCaseExecutor.initExecutor();
        for (TestFitnessFunction goal : goals) {
            BranchCoverageTestFitness branchGoal = (BranchCoverageTestFitness)goal;
            if (branchGoal.getBranch() == null || branchGoal.getBranch().isInstrumented()) continue;
            Assert.assertTrue((boolean)branchGoal.isCoveredBy(best));
        }
    }

    @Test
    public void testLinkedListIndexWithoutErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = LinkedListAccessIndex.class.getCanonicalName();
        Properties.ERROR_BRANCHES = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)3L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testLinkedListIndexWithErrorBranches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = LinkedListAccessIndex.class.getCanonicalName();
        Properties.ERROR_BRANCHES = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        List goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)15L, (long)goals.size());
        TestCaseExecutor.initExecutor();
        for (TestFitnessFunction goal : goals) {
            BranchCoverageTestFitness branchGoal = (BranchCoverageTestFitness)goal;
            if (branchGoal.getBranch() == null || branchGoal.getBranch().isInstrumented()) continue;
            Assert.assertTrue((boolean)branchGoal.isCoveredBy(best));
        }
    }
}

