/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.mock.java.io;

import com.examples.with.different.packagename.mock.java.io.CreateNewTmpFile;
import com.examples.with.different.packagename.mock.java.io.FileAsInputExist;
import com.examples.with.different.packagename.mock.java.io.FileExist;
import com.examples.with.different.packagename.mock.java.io.ReadHelloWorldFromFileWithNameAsInput;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MockFileSystemTest
extends SystemTest {
    private static final boolean VFS = Properties.VIRTUAL_FS;
    private static final double defaultPoolP = Properties.SEED_CLONE;

    @After
    public void restoreProperties() {
        Properties.VIRTUAL_FS = VFS;
        Properties.SEED_CLONE = defaultPoolP;
    }

    @Test
    public void testCreateNewTmpFile() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = CreateNewTmpFile.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 20000L;
        Properties.VIRTUAL_FS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)3L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testFileAsInputExist() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = FileAsInputExist.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 20000L;
        Properties.VIRTUAL_FS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)3L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testFileExist() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = FileExist.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 20000L;
        Properties.VIRTUAL_FS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)3L, (long)goals);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testReadHelloWorldFromFileWithNameAsInput() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ReadHelloWorldFromFileWithNameAsInput.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 30000L;
        Properties.VIRTUAL_FS = true;
        Properties.SEED_CLONE = 0.5;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)5L, (long)goals);
        Assert.assertTrue((String)("Coverage: " + best.getCoverage()), (best.getCoverage() >= 0.8 ? 1 : 0) != 0);
    }
}

