/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.sandbox;

import com.examples.with.different.packagename.DeleteFileCommonsIO;
import com.examples.with.different.packagename.DeleteFileExample;
import com.examples.with.different.packagename.DeleteFileProcess;
import com.examples.with.different.packagename.DeleteFileThread;
import com.examples.with.different.packagename.sandbox.DeleteInStaticInitializer;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class DeleteFileTest
extends SystemTest {
    private static final boolean DEFAULT_RESET_STATIC = Properties.RESET_STATIC_FIELDS;

    @After
    public void tearDown() {
        Properties.RESET_STATIC_FIELDS = DEFAULT_RESET_STATIC;
    }

    @Test
    public void testDeleteStaticNoReset() throws IOException {
        String targetClass;
        Properties.RESET_STATIC_FIELDS = false;
        String tmpdir = System.getProperty("java.io.tmpdir");
        File toDelete = new File(tmpdir + File.separator + "this_file_should_not_be_deleted_by_evosuite");
        FileUtils.write((File)toDelete, (CharSequence)"BlahBlah");
        Assert.assertTrue((boolean)toDelete.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DeleteInStaticInitializer.class.getCanonicalName();
        Properties.SANDBOX = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertTrue((String)("File has been deleted: " + toDelete.getAbsolutePath()), (boolean)toDelete.exists());
        toDelete.delete();
    }

    @Test
    public void testDeleteStaticWithReset() throws IOException {
        String targetClass;
        Properties.RESET_STATIC_FIELDS = true;
        String tmpdir = System.getProperty("java.io.tmpdir");
        File toDelete = new File(tmpdir + File.separator + "this_file_should_not_be_deleted_by_evosuite");
        FileUtils.write((File)toDelete, (CharSequence)"BlahBlah");
        Assert.assertTrue((boolean)toDelete.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DeleteInStaticInitializer.class.getCanonicalName();
        Properties.SANDBOX = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertTrue((String)("File has been deleted: " + toDelete.getAbsolutePath()), (boolean)toDelete.exists());
        toDelete.delete();
    }

    @Test
    public void testDeleteOnExit() throws IOException {
        String targetClass;
        String tmpdir = System.getProperty("java.io.tmpdir");
        File toDelete = new File(tmpdir + File.separator + "this_file_should_not_be_deleted_by_evosuite");
        FileUtils.write((File)toDelete, (CharSequence)"BlahBlah");
        Assert.assertTrue((boolean)toDelete.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DeleteFileExample.class.getCanonicalName();
        Properties.SANDBOX = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertTrue((String)("File has been deleted: " + toDelete.getAbsolutePath()), (boolean)toDelete.exists());
        toDelete.delete();
    }

    @Test
    public void testDeleteOnThread() throws IOException {
        String targetClass;
        String tmpdir = System.getProperty("java.io.tmpdir");
        File toDelete = new File(tmpdir + File.separator + "this_file_should_not_be_deleted_by_evosuite");
        FileUtils.write((File)toDelete, (CharSequence)"BlahBlah");
        Assert.assertTrue((boolean)toDelete.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DeleteFileThread.class.getCanonicalName();
        Properties.SANDBOX = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertTrue((String)("File has been deleted: " + toDelete.getAbsolutePath()), (boolean)toDelete.exists());
        toDelete.delete();
    }

    @Test
    public void testDeleteOnProcess() throws IOException {
        String targetClass;
        Assume.assumeTrue((boolean)new File("/bin/rm").exists());
        String tmpdir = System.getProperty("java.io.tmpdir");
        File toDelete = new File(tmpdir + File.separator + "this_file_should_not_be_deleted_by_evosuite");
        FileUtils.write((File)toDelete, (CharSequence)"BlahBlah");
        Assert.assertTrue((boolean)toDelete.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DeleteFileProcess.class.getCanonicalName();
        Properties.SANDBOX = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Assert.assertTrue((String)("File has been deleted: " + toDelete.getAbsolutePath()), (boolean)toDelete.exists());
        toDelete.delete();
    }

    @Test
    public void testDeleteCommonsIO() throws IOException {
        String targetClass;
        Assume.assumeTrue((boolean)new File("/bin/rm").exists());
        String tmpdir = System.getProperty("java.io.tmpdir");
        File toDelete = new File(tmpdir + File.separator + "this_file_should_not_be_deleted_by_evosuite");
        FileUtils.write((File)toDelete, (CharSequence)"BlahBlah");
        Assert.assertTrue((boolean)toDelete.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DeleteFileCommonsIO.class.getCanonicalName();
        Properties.SANDBOX = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)("File has been deleted: " + toDelete.getAbsolutePath()), (boolean)toDelete.exists());
        toDelete.delete();
    }
}

