/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.sandbox;

import com.examples.with.different.packagename.sandbox.OpenStream;
import com.examples.with.different.packagename.sandbox.OpenStreamInATryCatch;
import com.examples.with.different.packagename.sandbox.OpenStreamInSpecificTryCatch;
import java.io.File;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeneratedFilesEvenWithSandboxTest
extends SystemTest {
    public static final boolean DEFAULT_VFS = Properties.VIRTUAL_FS;
    public static final boolean DEFAULT_SANDBOX = Properties.SANDBOX;
    private File file = new File("OpenStream_foo.txt");

    @Before
    public void init() {
        if (this.file.exists()) {
            this.file.delete();
        }
        this.file.deleteOnExit();
    }

    @After
    public void tearDown() {
        Properties.VIRTUAL_FS = DEFAULT_VFS;
        Properties.SANDBOX = DEFAULT_SANDBOX;
    }

    @Test
    public void testCreateWithNoCatch() {
        String targetClass;
        Assert.assertFalse((boolean)this.file.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = OpenStream.class.getCanonicalName();
        Properties.SANDBOX = true;
        Properties.JUNIT_TESTS = true;
        Properties.VIRTUAL_FS = false;
        Properties.JUNIT_CHECK_ON_SEPARATE_PROCESS = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)3L, (long)goals);
        Assert.assertTrue((String)"Should not achieve optimal coverage ", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.file.exists());
    }

    @Test
    public void testCreateInATryCatch() {
        String targetClass;
        Assert.assertFalse((boolean)this.file.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = OpenStreamInATryCatch.class.getCanonicalName();
        Properties.SANDBOX = true;
        Properties.JUNIT_TESTS = true;
        Properties.VIRTUAL_FS = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)5L, (long)goals);
        Assert.assertEquals((String)"", (double)0.8, (double)best.getCoverage(), (double)0.001);
        System.out.println(best.toString());
        Assert.assertFalse((boolean)this.file.exists());
    }

    @Test
    public void testCreateInATryCatchThatDoesNotCatchSecurityException() {
        String targetClass;
        Assert.assertFalse((boolean)this.file.exists());
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = OpenStreamInSpecificTryCatch.class.getCanonicalName();
        Properties.SANDBOX = true;
        Properties.JUNIT_TESTS = true;
        Properties.VIRTUAL_FS = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((String)"Wrong number of goals: ", (long)3L, (long)goals);
        Assert.assertTrue((String)"Should not achive optimala coverage ", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
        System.out.println(best.toString());
        Assert.assertFalse((boolean)this.file.exists());
    }
}

