/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.sandbox;

import com.examples.with.different.packagename.sandbox.ReadLineSeparator;
import com.examples.with.different.packagename.sandbox.ReadWriteSystemProperties;
import java.util.List;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.junit.JUnitAnalyzer;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReadWriteSystemPropertiesTest
extends SystemTest {
    private static final String userDir = System.getProperty("user.dir");
    private static final String aProperty = System.getProperty("a property with a ridiculosly long value and different characters $#%@!*$");
    private final boolean DEFAULT_REPLACE_CALLS = Properties.REPLACE_CALLS;

    @After
    public void reset() {
        Properties.REPLACE_CALLS = this.DEFAULT_REPLACE_CALLS;
    }

    @BeforeClass
    public static void checkStatus() {
        Assert.assertNull((Object)aProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLineSeparator() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ReadLineSeparator.class.getCanonicalName();
        Properties.SANDBOX = true;
        Properties.REPLACE_CALLS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        double cov = best.getCoverage();
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)cov, (double)0.001);
        List list = best.getTests();
        int n = list.size();
        Assert.assertTrue((n > 0 ? 1 : 0) != 0);
        TestCaseExecutor.initExecutor();
        try {
            Sandbox.initializeSecurityManagerForSUT();
            JUnitAnalyzer.removeTestsThatDoNotCompile((List)list);
        }
        finally {
            Sandbox.resetDefaultSecurityManager();
        }
        Assert.assertEquals((long)n, (long)list.size());
        TestGenerationResult tgr = TestGenerationResultBuilder.buildSuccessResult();
        String code = tgr.getTestSuiteCode();
        Assert.assertTrue((String)("Test code:\n" + code), (boolean)code.contains("line.separator"));
        Assert.assertTrue((String)("Test code:\n" + code), (!code.contains("debug") ? 1 : 0) != 0);
    }

    @Test
    public void testNoReplace() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ReadWriteSystemProperties.class.getCanonicalName();
        Properties.SANDBOX = true;
        Properties.REPLACE_CALLS = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        double cov = best.getCoverage();
        Assert.assertTrue((cov < 1.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithReplace() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ReadWriteSystemProperties.class.getCanonicalName();
        Properties.SANDBOX = true;
        Properties.REPLACE_CALLS = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        double cov = best.getCoverage();
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)cov, (double)0.001);
        String currentUserDir = System.getProperty("user.dir");
        String currentAProperty = System.getProperty("a property with a ridiculosly long value and different characters $#%@!*$");
        Assert.assertEquals((Object)userDir, (Object)currentUserDir);
        Assert.assertEquals((Object)aProperty, (Object)currentAProperty);
        List list = best.getTests();
        int n = list.size();
        Assert.assertTrue((n > 0 ? 1 : 0) != 0);
        TestCaseExecutor.initExecutor();
        try {
            Sandbox.initializeSecurityManagerForSUT();
            for (TestCase tc : list) {
                Assert.assertFalse((boolean)tc.isUnstable());
            }
            JUnitAnalyzer.removeTestsThatDoNotCompile((List)list);
            Assert.assertEquals((long)n, (long)list.size());
            JUnitAnalyzer.handleTestsThatAreUnstable((List)list);
            Assert.assertEquals((long)n, (long)list.size());
            for (TestCase tc : list) {
                Assert.assertFalse((boolean)tc.isUnstable());
            }
            Assert.assertEquals((Object)userDir, (Object)currentUserDir);
            Assert.assertEquals((Object)aProperty, (Object)currentAProperty);
        }
        finally {
            Sandbox.resetDefaultSecurityManager();
        }
    }
}

