/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import com.examples.with.different.packagename.seeding.NumericDynamicDoubleSeeding;
import com.examples.with.different.packagename.seeding.NumericDynamicFloatSeeding;
import com.examples.with.different.packagename.seeding.NumericDynamicIntSeeding;
import com.examples.with.different.packagename.seeding.NumericDynamicLongSeeding;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.Test;

public class TestNumericDynamicSeeding
extends SystemTest {
    public static final double defaultDynamicPool = Properties.DYNAMIC_POOL;

    @Test
    public void testDynamicSeedingDouble() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NumericDynamicDoubleSeeding.class.getCanonicalName();
        Properties.CLIENT_ON_THREAD = true;
        Properties.DYNAMIC_SEEDING = true;
        Properties.DYNAMIC_POOL = 0.8;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        System.out.println("ConstantPool:\n" + ConstantPoolManager.getInstance().getDynamicConstantPool().toString());
    }

    @Test
    public void testDynamicSeedingDoubleOff() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NumericDynamicDoubleSeeding.class.getCanonicalName();
        Properties.CLIENT_ON_THREAD = true;
        Properties.DYNAMIC_SEEDING = false;
        Properties.DYNAMIC_POOL = 0.5;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        System.out.println("ConstantPool:\n" + ConstantPoolManager.getInstance().getDynamicConstantPool().toString());
    }

    @Test
    public void testDynamicSeedingFloat() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NumericDynamicFloatSeeding.class.getCanonicalName();
        Properties.CLIENT_ON_THREAD = true;
        Properties.DYNAMIC_SEEDING = true;
        Properties.DYNAMIC_POOL = 0.8f;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        System.out.println("ConstantPool:\n" + ConstantPoolManager.getInstance().getDynamicConstantPool().toString());
    }

    @Test
    public void testDynamicSeedingFloatOff() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NumericDynamicFloatSeeding.class.getCanonicalName();
        Properties.CLIENT_ON_THREAD = true;
        Properties.DYNAMIC_SEEDING = false;
        Properties.DYNAMIC_POOL = 0.0;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        System.out.println("ConstantPool:\n" + ConstantPoolManager.getInstance().getDynamicConstantPool().toString());
    }

    @Test
    public void testDynamicSeedingLong() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NumericDynamicLongSeeding.class.getCanonicalName();
        Properties.CLIENT_ON_THREAD = true;
        Properties.DYNAMIC_SEEDING = true;
        Properties.DYNAMIC_POOL = 0.5;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        System.out.println("ConstantPool:\n" + ConstantPoolManager.getInstance().getDynamicConstantPool().toString());
    }

    @Test
    public void testDynamicSeedingLongOff() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NumericDynamicLongSeeding.class.getCanonicalName();
        Properties.CLIENT_ON_THREAD = true;
        Properties.DYNAMIC_SEEDING = false;
        Properties.DYNAMIC_POOL = 0.5;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        System.out.println("ConstantPool:\n" + ConstantPoolManager.getInstance().getDynamicConstantPool().toString());
    }

    @Test
    public void testDynamicSeedingInt() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NumericDynamicIntSeeding.class.getCanonicalName();
        Properties.CLIENT_ON_THREAD = true;
        Properties.DYNAMIC_SEEDING = true;
        Properties.DYNAMIC_POOL = 0.3333333333333333;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        System.out.println("ConstantPool:\n" + ConstantPoolManager.getInstance().getDynamicConstantPool().toString());
    }

    @Test
    public void testDynamicSeedingIntOff() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NumericDynamicIntSeeding.class.getCanonicalName();
        Properties.CLIENT_ON_THREAD = true;
        Properties.DYNAMIC_SEEDING = false;
        Properties.DYNAMIC_POOL = 0.3333333333333333;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass, "-Dprint_to_system=true"};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        System.out.println("ConstantPool:\n" + ConstantPoolManager.getInstance().getDynamicConstantPool().toString());
    }
}

