/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import com.examples.with.different.packagename.testcarver.ArrayConverterTestCase;
import com.examples.with.different.packagename.testcarver.DifficultClassTest;
import com.examples.with.different.packagename.testcarver.DifficultClassWithoutCarving;
import com.examples.with.different.packagename.testcarver.DifficultClassWithoutCarvingTest;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestObjectPool
extends SystemTest {
    private double P_POOL = Properties.P_OBJECT_POOL;
    private boolean CARVE_POOL = Properties.CARVE_OBJECT_POOL;
    private String SELECTED_JUNIT = Properties.SELECTED_JUNIT;
    private Properties.TestFactory FACTORY = Properties.TEST_FACTORY;

    @After
    public void restoreProperties() {
        Properties.P_OBJECT_POOL = this.P_POOL;
        Properties.CARVE_OBJECT_POOL = this.CARVE_POOL;
        Properties.SELECTED_JUNIT = this.SELECTED_JUNIT;
        Properties.TEST_FACTORY = this.FACTORY;
    }

    @Test
    public void testDifficultClassWithoutPoolFails() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DifficultClassWithoutCarving.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 0.0;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Did not expect optimal coverage: ", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDifficultClassWithWrongPoolFails() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DifficultClassWithoutCarving.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 0.8;
        Properties.CARVE_OBJECT_POOL = true;
        Properties.SELECTED_JUNIT = ArrayConverterTestCase.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Did not expect optimal coverage: ", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDifficultClassWithPoolPasses() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DifficultClassWithoutCarving.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 0.8;
        Properties.CARVE_OBJECT_POOL = true;
        Properties.SELECTED_JUNIT = DifficultClassTest.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Expected optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testDifficultClassWithMultipleClassPoolPasses() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DifficultClassWithoutCarving.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 0.8;
        Properties.CARVE_OBJECT_POOL = true;
        Properties.SELECTED_JUNIT = DifficultClassWithoutCarvingTest.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Expected optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }
}

