/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import com.examples.with.different.packagename.TrivialForDynamicSeeding;
import com.examples.with.different.packagename.TrivialForDynamicSeedingEndsWith;
import com.examples.with.different.packagename.TrivialForDynamicSeedingRegex;
import com.examples.with.different.packagename.TrivialForDynamicSeedingRegionMatches;
import com.examples.with.different.packagename.TrivialForDynamicSeedingRegionMatchesCase;
import com.examples.with.different.packagename.TrivialForDynamicSeedingStartsWith;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestTrivialForDynamicSeeding
extends SystemTest {
    public static final double defaultDynamicPool = Properties.DYNAMIC_POOL;

    @After
    public void resetProperties() {
        Properties.DYNAMIC_POOL = defaultDynamicPool;
    }

    @Test
    public void testConcatenatedStringEquals() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeeding.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.3333333333333333;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testConcatenatedStringEqualsWithoutSeeding() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeeding.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.0;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Unexpected coverage: ", (double)0.6666666666666666, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testStartsWith() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingStartsWith.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.3333333333333333;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testStartsWithWithoutSeeding() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingStartsWith.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.0;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Unexpected coverage: ", (double)0.6666666666666666, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testEndsWith() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingEndsWith.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.3333333333333333;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testEndsWithWithoutSeeding() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingEndsWith.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.0;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Unexpected coverage: ", (double)0.6666666666666666, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testRegionMatches() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingRegionMatches.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.3333333333333333;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testRegionMatchesWithoutSeeding() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingRegionMatches.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.0;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Unexpected coverage: ", (double)0.6666666666666666, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testRegionMatchesIgnoreCase() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingRegionMatchesCase.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.3333333333333333;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testRegionMatchesIgnoreCaseWithoutSeeding() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingRegionMatchesCase.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.0;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Unexpected coverage: ", (double)0.6666666666666666, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testRegexStringMatches() {
        String targetClass;
        String example = "-@0.AA";
        Assert.assertTrue((boolean)"-@0.AA".matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$"));
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingRegex.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.99;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        ConstantPoolManager foo = ConstantPoolManager.getInstance();
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testRegexStringMatchesWithoutSeeding() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = TrivialForDynamicSeedingRegex.class.getCanonicalName();
        Properties.DYNAMIC_POOL = 0.0;
        ConstantPoolManager.getInstance().reset();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Unexpected coverage: ", (double)0.6666666666666666, (double)best.getCoverage(), (double)0.001);
    }
}

