/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import com.examples.with.different.packagename.Calculator;
import com.examples.with.different.packagename.ExampleGradientBranches;
import com.examples.with.different.packagename.statistics.MultiThreads;
import com.examples.with.different.packagename.statistics.NoThreads;
import java.util.Map;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.backend.DebugStatisticsBackend;
import org.junit.Assert;
import org.junit.Test;

public class SearchStatisticsSystemTest
extends SystemTest {
    @Test
    public void testHandlingOfNoThreads() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = NoThreads.class.getCanonicalName();
        Properties.SANDBOX = true;
        Properties.OUTPUT_VARIABLES = "" + RuntimeVariable.Threads;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Map map = DebugStatisticsBackend.getLatestWritten();
        Assert.assertNotNull((Object)map);
        OutputVariable threads = (OutputVariable)map.get(RuntimeVariable.Threads.toString());
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((Object)1, (Object)threads.getValue());
    }

    @Test
    public void testHandlingOfMultiThreads() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = MultiThreads.class.getCanonicalName();
        Properties.SANDBOX = true;
        Properties.OUTPUT_VARIABLES = "" + RuntimeVariable.Threads;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Map map = DebugStatisticsBackend.getLatestWritten();
        Assert.assertNotNull((Object)map);
        OutputVariable threads = (OutputVariable)map.get(RuntimeVariable.Threads.toString());
        Assert.assertNotNull((Object)threads);
        Assert.assertEquals((Object)3, (Object)threads.getValue());
    }

    @Test
    public void testBranchlessMethodsOutputVariables() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = Calculator.class.getCanonicalName();
        Properties.DYNAMIC_SEEDING = true;
        Properties.SEARCH_BUDGET = 30L;
        Properties.OUTPUT_VARIABLES = "" + RuntimeVariable.Branchless_Methods + "," + RuntimeVariable.Covered_Branchless_Methods;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Map map = DebugStatisticsBackend.getLatestWritten();
        Assert.assertNotNull((Object)map);
        OutputVariable branchlessMethods = (OutputVariable)map.get(RuntimeVariable.Branchless_Methods.toString());
        OutputVariable coveredBranchlessMethods = (OutputVariable)map.get(RuntimeVariable.Covered_Branchless_Methods.toString());
        Assert.assertNotNull((Object)branchlessMethods);
        Assert.assertNotNull((Object)coveredBranchlessMethods);
        Assert.assertEquals((Object)5, (Object)branchlessMethods.getValue());
        Assert.assertEquals((Object)5, (Object)coveredBranchlessMethods.getValue());
    }

    @Test
    public void testGradientBranchesOutputVariable() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ExampleGradientBranches.class.getCanonicalName();
        Properties.DYNAMIC_SEEDING = true;
        Properties.SEARCH_BUDGET = 30L;
        Properties.TRACK_BOOLEAN_BRANCHES = true;
        Properties.OUTPUT_VARIABLES = "" + RuntimeVariable.Coverage + "," + RuntimeVariable.Gradient_Branches;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Map map = DebugStatisticsBackend.getLatestWritten();
        Assert.assertNotNull((Object)map);
        OutputVariable coverage = (OutputVariable)map.get(RuntimeVariable.Coverage.toString());
        Assert.assertNotNull((Object)coverage);
        Assert.assertEquals((Object)1.0, (Object)coverage.getValue());
        OutputVariable gradientBranches = (OutputVariable)map.get(RuntimeVariable.Gradient_Branches.toString());
        Assert.assertNotNull((Object)gradientBranches);
        Assert.assertEquals((Object)4, (Object)gradientBranches.getValue());
    }

    private OutputVariable getLastTimelineVariable(Map<String, OutputVariable<?>> map, String name) {
        OutputVariable<?> timelineVar = null;
        int max = -1;
        for (Map.Entry<String, OutputVariable<?>> e : map.entrySet()) {
            int index;
            if (!e.getKey().startsWith(name) || (index = Integer.parseInt(e.getKey().split("_T")[1])) <= max) continue;
            max = index;
            timelineVar = e.getValue();
        }
        return timelineVar;
    }
}

