/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import com.examples.with.different.packagename.Compositional;
import java.util.Arrays;
import java.util.Map;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.backend.DebugStatisticsBackend;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TimelineForCombinedFitness1Test
extends SystemTest {
    private final Properties.Criterion[] oldCriterion = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length);
    private final boolean COMPOSITIONAL_FITNESS = Properties.COMPOSITIONAL_FITNESS;
    private final String ANALYSIS_CRITERIA = Properties.ANALYSIS_CRITERIA;
    private final boolean ASSERTIONS = Properties.ASSERTIONS;

    @After
    public void afterTest() {
        Properties.CRITERION = this.oldCriterion;
        Properties.COMPOSITIONAL_FITNESS = this.COMPOSITIONAL_FITNESS;
        Properties.ANALYSIS_CRITERIA = this.ANALYSIS_CRITERIA;
        Properties.ASSERTIONS = this.ASSERTIONS;
    }

    @Test
    public void testTimelineForCombinedFitness() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.ASSERTIONS = false;
        Properties.TARGET_CLASS = targetClass = Compositional.class.getCanonicalName();
        Properties.COMPOSITIONAL_FITNESS = true;
        Properties.CRITERION = new Properties.Criterion[4];
        Properties.CRITERION[0] = Properties.Criterion.ONLYBRANCH;
        Properties.CRITERION[1] = Properties.Criterion.METHODNOEXCEPTION;
        Properties.CRITERION[2] = Properties.Criterion.METHOD;
        Properties.CRITERION[3] = Properties.Criterion.OUTPUT;
        StringBuilder s = new StringBuilder();
        s.append(RuntimeVariable.CoverageTimeline);
        s.append(",");
        s.append(RuntimeVariable.OnlyBranchCoverageTimeline);
        s.append(",");
        s.append(RuntimeVariable.MethodCoverageTimeline);
        s.append(",");
        s.append(RuntimeVariable.MethodNoExceptionCoverageTimeline);
        s.append(",");
        s.append(RuntimeVariable.OutputCoverageTimeline);
        Properties.OUTPUT_VARIABLES = s.toString();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
        Map map = DebugStatisticsBackend.getLatestWritten();
        Assert.assertNotNull((Object)map);
        String strVar1 = RuntimeVariable.MethodCoverageTimeline.toString();
        OutputVariable method = this.getLastTimelineVariable(map, strVar1);
        Assert.assertNotNull((Object)method);
        Assert.assertEquals((String)("Incorrect last timeline value for " + strVar1), (Object)1.0, (Object)method.getValue());
        String strVar2 = RuntimeVariable.MethodNoExceptionCoverageTimeline.toString();
        OutputVariable methodNE = this.getLastTimelineVariable(map, strVar2);
        Assert.assertNotNull((Object)methodNE);
        Assert.assertEquals((String)("Incorrect last timeline value for " + strVar2), (Object)1.0, (Object)methodNE.getValue());
        String strVar3 = RuntimeVariable.OutputCoverageTimeline.toString();
        OutputVariable output = this.getLastTimelineVariable(map, strVar3);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((String)("Incorrect last timeline value for " + strVar3), (Object)1.0, (Object)output.getValue());
    }

    private OutputVariable getLastTimelineVariable(Map<String, OutputVariable<?>> map, String name) {
        OutputVariable<?> timelineVar = null;
        int max = -1;
        for (Map.Entry<String, OutputVariable<?>> e : map.entrySet()) {
            int index;
            if (!e.getKey().startsWith(name) || (index = Integer.parseInt(e.getKey().split("_T")[1])) <= max) continue;
            max = index;
            timelineVar = e.getValue();
        }
        return timelineVar;
    }
}

