/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.examples.with.different.packagename.FactoryExample;
import java.util.List;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestGenerationContext;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.VariableReference;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericField;
import org.evosuite.utils.GenericMethod;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFactoryTest
extends SystemTest {
    private double P_OBJECT_REUSE = Properties.OBJECT_REUSE_PROBABILITY;
    private double P_PRIMITIVE_REUSE = Properties.PRIMITIVE_REUSE_PROBABILITY;

    @After
    public void restoreProperties() {
        Properties.OBJECT_REUSE_PROBABILITY = this.P_OBJECT_REUSE;
        Properties.PRIMITIVE_REUSE_PROBABILITY = this.P_PRIMITIVE_REUSE;
    }

    @Before
    public void setupCluster() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = FactoryExample.class.getCanonicalName();
        Properties.ASSERTIONS = false;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        evosuite.parseCommandLine(command);
    }

    @Test
    public void testTestCalls() throws ConstructionFailedException, NoSuchMethodException, SecurityException {
        List testCalls = TestCluster.getInstance().getTestCalls();
        System.out.println(testCalls.toString());
        Assert.assertEquals((String)("Expected 4 test calls, but got: " + testCalls.size() + ": " + testCalls), (long)4L, (long)testCalls.size());
    }

    @Test
    public void testIntegerDependency() throws ConstructionFailedException, NoSuchMethodException, SecurityException {
        TestFactory testFactory = TestFactory.getInstance();
        GenericMethod method = new GenericMethod(FactoryExample.class.getMethod("testByte", Byte.TYPE, Byte.TYPE), FactoryExample.class);
        DefaultTestCase test = new DefaultTestCase();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        testFactory.addMethod((TestCase)test, method, 0, 0);
        String code = test.toCode();
        System.out.println(code);
        Assert.assertEquals((long)4L, (long)test.size());
        Assert.assertTrue((boolean)code.contains("factoryExample0.testByte(byte0, byte1)"));
    }

    @Test
    public void testObjectDependencyReuse() throws ConstructionFailedException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericMethod method = new GenericMethod(sut.getMethod("testByte", Byte.TYPE, Byte.TYPE), sut);
        DefaultTestCase test = new DefaultTestCase();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 1.0;
        Properties.OBJECT_REUSE_PROBABILITY = 1.0;
        testFactory.addMethod((TestCase)test, method, 0, 0);
        testFactory.addMethod((TestCase)test, method, 3, 0);
        String code = test.toCode();
        System.out.println(code);
        Assert.assertEquals((long)4L, (long)test.size());
        Assert.assertTrue((boolean)code.contains("factoryExample0.testByte(byte0, byte0)"));
        Assert.assertFalse((boolean)code.contains("factoryExample1"));
    }

    @Test
    public void testObjectDependencyNoReuse() throws ConstructionFailedException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericMethod method = new GenericMethod(sut.getMethod("testByte", Byte.TYPE, Byte.TYPE), sut);
        DefaultTestCase test = new DefaultTestCase();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        Properties.OBJECT_REUSE_PROBABILITY = 0.0;
        testFactory.addMethod((TestCase)test, method, 0, 0);
        testFactory.reset();
        testFactory.addMethod((TestCase)test, method, 4, 0);
        String code = test.toCode();
        System.out.println(code);
        Assert.assertEquals((long)8L, (long)test.size());
        Assert.assertTrue((boolean)code.contains("factoryExample0.testByte(byte0, byte1)"));
        Assert.assertTrue((boolean)code.contains("factoryExample1.testByte(byte3, byte4"));
    }

    @Test
    public void testStaticMethod() throws ConstructionFailedException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericMethod method = new GenericMethod(sut.getMethod("testStatic", new Class[0]), sut);
        DefaultTestCase test = new DefaultTestCase();
        testFactory.addMethod((TestCase)test, method, 0, 0);
        Assert.assertEquals((long)1L, (long)test.size());
        testFactory.reset();
        testFactory.addMethod((TestCase)test, method, 1, 0);
        Assert.assertEquals((long)2L, (long)test.size());
        String code = test.toCode();
        System.out.println(code);
        Assert.assertTrue((boolean)code.contains("FactoryExample.testStatic()"));
        Assert.assertFalse((boolean)code.contains("FactoryExample0"));
    }

    @Test
    public void testMethodFor() throws ConstructionFailedException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericConstructor constructor = new GenericConstructor(sut.getConstructor(new Class[0]), sut);
        GenericMethod method = new GenericMethod(sut.getMethod("testByte", Byte.TYPE, Byte.TYPE), sut);
        DefaultTestCase test = new DefaultTestCase();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        Properties.OBJECT_REUSE_PROBABILITY = 0.0;
        VariableReference var1 = testFactory.addConstructor((TestCase)test, constructor, 0, 0);
        testFactory.reset();
        VariableReference var2 = testFactory.addConstructor((TestCase)test, constructor, 1, 0);
        testFactory.addMethodFor((TestCase)test, var1, method, 2);
        testFactory.reset();
        testFactory.addMethodFor((TestCase)test, var2, method, 3);
        String code = test.toCode();
        System.out.println(code);
        Assert.assertEquals((long)8L, (long)test.size());
        Assert.assertTrue((boolean)code.contains("factoryExample0.testByte"));
        Assert.assertTrue((boolean)code.contains("factoryExample1.testByte"));
    }

    @Test(expected=ConstructionFailedException.class)
    public void testMethodForWrongPosition() throws ConstructionFailedException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericConstructor constructor = new GenericConstructor(sut.getConstructor(new Class[0]), sut);
        GenericMethod method = new GenericMethod(sut.getMethod("testByte", Byte.TYPE, Byte.TYPE), sut);
        DefaultTestCase test = new DefaultTestCase();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        Properties.OBJECT_REUSE_PROBABILITY = 0.0;
        VariableReference var1 = testFactory.addConstructor((TestCase)test, constructor, 0, 0);
        testFactory.reset();
        testFactory.addMethodFor((TestCase)test, var1, method, 0);
    }

    @Test
    public void testAddConstructor() throws ConstructionFailedException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericConstructor method = new GenericConstructor(sut.getConstructor(new Class[0]), sut);
        DefaultTestCase test = new DefaultTestCase();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        Properties.OBJECT_REUSE_PROBABILITY = 0.0;
        testFactory.addConstructor((TestCase)test, method, 0, 0);
        testFactory.reset();
        Assert.assertEquals((long)1L, (long)test.size());
        testFactory.addConstructor((TestCase)test, method, 0, 0);
        Assert.assertEquals((long)2L, (long)test.size());
        String code = test.toCode();
        System.out.println(code);
        Assert.assertTrue((boolean)code.contains("factoryExample0"));
        Assert.assertTrue((boolean)code.contains("factoryExample1"));
    }

    @Test
    public void testAddField() throws ConstructionFailedException, NoSuchMethodException, SecurityException, NoSuchFieldException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericField field = new GenericField(sut.getField("setMe"), sut);
        DefaultTestCase test = new DefaultTestCase();
        testFactory.addField((TestCase)test, field, 0, 0);
        Assert.assertEquals((long)2L, (long)test.size());
        String code = test.toCode();
        System.out.println(code);
        Assert.assertTrue((boolean)code.contains("factoryExample0.setMe"));
        Assert.assertFalse((boolean)code.contains("factoryExample1"));
    }

    @Test
    public void testAddFieldReuse() throws ConstructionFailedException, NoSuchMethodException, SecurityException, NoSuchFieldException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericField field = new GenericField(sut.getField("setMe"), sut);
        DefaultTestCase test = new DefaultTestCase();
        testFactory.addField((TestCase)test, field, 0, 0);
        Assert.assertEquals((long)2L, (long)test.size());
        Properties.PRIMITIVE_REUSE_PROBABILITY = 1.0;
        Properties.OBJECT_REUSE_PROBABILITY = 1.0;
        testFactory.reset();
        testFactory.addField((TestCase)test, field, 2, 0);
        Assert.assertEquals((long)3L, (long)test.size());
        String code = test.toCode();
        System.out.println(code);
        Assert.assertTrue((boolean)code.contains("factoryExample0.setMe"));
        Assert.assertFalse((boolean)code.contains("factoryExample1"));
    }

    @Test
    public void testAddFieldNoreuse() throws ConstructionFailedException, NoSuchMethodException, SecurityException, NoSuchFieldException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericField field = new GenericField(sut.getField("setMe"), sut);
        DefaultTestCase test = new DefaultTestCase();
        testFactory.addField((TestCase)test, field, 0, 0);
        Assert.assertEquals((long)2L, (long)test.size());
        testFactory.reset();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        Properties.OBJECT_REUSE_PROBABILITY = 0.0;
        testFactory.addField((TestCase)test, field, 2, 0);
        System.out.println(test.toCode());
        Assert.assertEquals((long)4L, (long)test.size());
        String code = test.toCode();
        System.out.println(code);
        Assert.assertTrue((boolean)code.contains("factoryExample0.setMe"));
        Assert.assertTrue((boolean)code.contains("factoryExample1.setMe"));
        Assert.assertFalse((boolean)code.contains("factoryExample2"));
    }

    @Test
    public void testFieldFor() throws ConstructionFailedException, NoSuchMethodException, SecurityException, ClassNotFoundException, NoSuchFieldException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericConstructor constructor = new GenericConstructor(sut.getConstructor(new Class[0]), sut);
        GenericField field = new GenericField(sut.getField("setMe"), sut);
        DefaultTestCase test = new DefaultTestCase();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        Properties.OBJECT_REUSE_PROBABILITY = 0.0;
        VariableReference var1 = testFactory.addConstructor((TestCase)test, constructor, 0, 0);
        testFactory.reset();
        VariableReference var2 = testFactory.addConstructor((TestCase)test, constructor, 1, 0);
        testFactory.addFieldFor((TestCase)test, var1, field, 2);
        testFactory.reset();
        testFactory.addFieldFor((TestCase)test, var2, field, 3);
        String code = test.toCode();
        System.out.println(code);
        Assert.assertEquals((long)6L, (long)test.size());
        Assert.assertTrue((boolean)code.contains("factoryExample0.setMe"));
        Assert.assertTrue((boolean)code.contains("factoryExample1.setMe"));
    }

    @Test(expected=ConstructionFailedException.class)
    public void testFieldForWrongPosition() throws ConstructionFailedException, NoSuchMethodException, SecurityException, ClassNotFoundException, NoSuchFieldException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericConstructor constructor = new GenericConstructor(sut.getConstructor(new Class[0]), sut);
        GenericField field = new GenericField(sut.getField("setMe"), sut);
        DefaultTestCase test = new DefaultTestCase();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        Properties.OBJECT_REUSE_PROBABILITY = 0.0;
        VariableReference var1 = testFactory.addConstructor((TestCase)test, constructor, 0, 0);
        testFactory.reset();
        testFactory.addFieldFor((TestCase)test, var1, field, 0);
    }

    @Test
    public void testAddFieldAssignment() throws ConstructionFailedException, NoSuchMethodException, SecurityException, NoSuchFieldException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericField field = new GenericField(sut.getField("setMe"), sut);
        DefaultTestCase test = new DefaultTestCase();
        testFactory.addFieldAssignment((TestCase)test, field, 0, 0);
        Assert.assertEquals((long)3L, (long)test.size());
        String code = test.toCode();
        System.out.println(code);
        Assert.assertTrue((boolean)code.contains("factoryExample0.setMe"));
        Assert.assertFalse((boolean)code.contains("factoryExample1"));
    }

    @Test
    public void testAddFieldAssignmentReuse() throws ConstructionFailedException, NoSuchMethodException, SecurityException, NoSuchFieldException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericField field = new GenericField(sut.getField("setMe"), sut);
        DefaultTestCase test = new DefaultTestCase();
        testFactory.addFieldAssignment((TestCase)test, field, 0, 0);
        Assert.assertEquals((long)3L, (long)test.size());
        Properties.PRIMITIVE_REUSE_PROBABILITY = 1.0;
        Properties.OBJECT_REUSE_PROBABILITY = 1.0;
        testFactory.reset();
        testFactory.addFieldAssignment((TestCase)test, field, 3, 0);
        Assert.assertEquals((long)4L, (long)test.size());
        String code = test.toCode();
        System.out.println(code);
        Assert.assertTrue((boolean)code.contains("factoryExample0.setMe"));
        Assert.assertFalse((boolean)code.contains("factoryExample1"));
    }

    @Test
    public void testAddFieldAssignmentNoreuse() throws ConstructionFailedException, NoSuchMethodException, SecurityException, NoSuchFieldException, ClassNotFoundException {
        TestFactory testFactory = TestFactory.getInstance();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(FactoryExample.class.getCanonicalName());
        GenericField field = new GenericField(sut.getField("setMe"), sut);
        DefaultTestCase test = new DefaultTestCase();
        testFactory.addFieldAssignment((TestCase)test, field, 0, 0);
        Assert.assertEquals((long)3L, (long)test.size());
        testFactory.reset();
        Properties.PRIMITIVE_REUSE_PROBABILITY = 0.0;
        Properties.OBJECT_REUSE_PROBABILITY = 0.0;
        testFactory.addFieldAssignment((TestCase)test, field, 3, 0);
        Assert.assertEquals((long)6L, (long)test.size());
        String code = test.toCode();
        System.out.println(code);
        Assert.assertTrue((boolean)code.contains("factoryExample0.setMe"));
        Assert.assertTrue((boolean)code.contains("factoryExample1.setMe"));
        Assert.assertFalse((boolean)code.contains("factoryExample2"));
    }
}

