/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.examples.with.different.packagename.localsearch.ArrayLocalSearchExample;
import com.examples.with.different.packagename.localsearch.DoubleLocalSearchExample;
import com.examples.with.different.packagename.localsearch.FloatLocalSearchExample;
import com.examples.with.different.packagename.localsearch.IntegerLocalSearchExample;
import com.examples.with.different.packagename.localsearch.StringLocalSearchExample;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.localsearch.BranchCoverageMap;
import org.evosuite.ga.localsearch.DefaultLocalSearchObjective;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.localsearch.TestSuiteLocalSearch;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.FloatPrimitiveStatement;
import org.evosuite.testcase.IntPrimitiveStatement;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.VariableReference;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericMethod;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalSearch
extends SystemTest {
    private static final int oldSearchRate = Properties.LOCAL_SEARCH_RATE;
    private static final double oldSearchProb = Properties.LOCAL_SEARCH_PROBABILITY;
    private static final Properties.LocalSearchBudgetType localSearchBudgetType = Properties.LOCAL_SEARCH_BUDGET_TYPE;
    private static final long oldSearchBudget = Properties.LOCAL_SEARCH_BUDGET;
    private static final boolean localSearchArrays = Properties.LOCAL_SEARCH_ARRAYS;
    private static final boolean localSearchPrimitives = Properties.LOCAL_SEARCH_PRIMITIVES;
    private static final boolean localSearchReferences = Properties.LOCAL_SEARCH_REFERENCES;
    private static final int chromosomeLength = Properties.CHROMOSOME_LENGTH;
    private static final int maxInitialTests = Properties.MAX_INITIAL_TESTS;

    @After
    public void resetLocalSearchRate() {
        Properties.LOCAL_SEARCH_RATE = oldSearchRate;
        Properties.LOCAL_SEARCH_PROBABILITY = oldSearchProb;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = localSearchBudgetType;
        Properties.LOCAL_SEARCH_BUDGET = oldSearchBudget;
        Properties.LOCAL_SEARCH_PRIMITIVES = localSearchPrimitives;
        Properties.LOCAL_SEARCH_REFERENCES = localSearchReferences;
        Properties.LOCAL_SEARCH_ARRAYS = localSearchArrays;
        Properties.CHROMOSOME_LENGTH = chromosomeLength;
        Properties.MAX_INITIAL_TESTS = maxInitialTests;
    }

    @Test
    public void testIntegerGlobalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = IntegerLocalSearchExample.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 20000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Did not expect optimal coverage", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerLocalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = IntegerLocalSearchExample.class.getCanonicalName();
        Properties.LOCAL_SEARCH_RATE = 1;
        Properties.LOCAL_SEARCH_PROBABILITY = 1.0;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.TESTS;
        Properties.LOCAL_SEARCH_REFERENCES = false;
        Properties.LOCAL_SEARCH_ARRAYS = false;
        Properties.SEARCH_BUDGET = 20000L;
        Properties.CHROMOSOME_LENGTH = 5;
        Properties.MAX_INITIAL_TESTS = 2;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testIntLocalSearchOnTest() throws ClassNotFoundException, ConstructionFailedException, NoSuchMethodException, SecurityException {
        Properties.TARGET_CLASS = IntegerLocalSearchExample.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.TESTS;
        Properties.LOCAL_SEARCH_REFERENCES = false;
        Properties.LOCAL_SEARCH_ARRAYS = false;
        Properties.PRINT_TO_SYSTEM = true;
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        VariableReference callee = testFactory.addConstructor((TestCase)test, gc, 0, 0);
        VariableReference intVar1 = test.addStatement((StatementInterface)new IntPrimitiveStatement((TestCase)test, Integer.valueOf(1)));
        VariableReference intVar0 = test.addStatement((StatementInterface)new IntPrimitiveStatement((TestCase)test, Integer.valueOf(1)));
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE, Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        MethodStatement ms = new MethodStatement((TestCase)test, method, callee, Arrays.asList(intVar0, intVar1));
        test.addStatement((StatementInterface)ms);
        System.out.println(test);
        TestSuiteChromosome suite = new TestSuiteChromosome();
        BranchCoverageSuiteFitness fitness = new BranchCoverageSuiteFitness();
        BranchCoverageMap.getInstance().searchStarted(null);
        Assert.assertEquals((double)4.0, (double)fitness.getFitness((AbstractTestSuiteChromosome)suite), (double)0.1f);
        suite.addTest((TestCase)test);
        Assert.assertEquals((double)1.0, (double)fitness.getFitness((AbstractTestSuiteChromosome)suite), (double)0.1f);
        TestSuiteLocalSearch localSearch = TestSuiteLocalSearch.getLocalSearch();
        DefaultLocalSearchObjective localObjective = new DefaultLocalSearchObjective((FitnessFunction)fitness);
        localSearch.doSearch((Chromosome)suite, (LocalSearchObjective)localObjective);
        System.out.println("Fitness: " + fitness.getFitness((AbstractTestSuiteChromosome)suite));
        System.out.println("Test suite: " + suite);
        Assert.assertEquals((double)0.0, (double)fitness.getFitness((AbstractTestSuiteChromosome)suite), (double)0.1f);
        BranchCoverageMap.getInstance().searchFinished(null);
    }

    @Test
    public void testFloatGlobalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = FloatLocalSearchExample.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Did not expect optimal coverage", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatLocalSearchOnTest() throws ClassNotFoundException, ConstructionFailedException, NoSuchMethodException, SecurityException {
        Properties.TARGET_CLASS = FloatLocalSearchExample.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.TESTS;
        Properties.LOCAL_SEARCH_REFERENCES = false;
        Properties.LOCAL_SEARCH_ARRAYS = false;
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        VariableReference callee = testFactory.addConstructor((TestCase)test, gc, 0, 0);
        VariableReference floatVar0 = test.addStatement((StatementInterface)new FloatPrimitiveStatement((TestCase)test, Float.valueOf(1.0f)));
        VariableReference floatVar1 = test.addStatement((StatementInterface)new FloatPrimitiveStatement((TestCase)test, Float.valueOf(1.0f)));
        Method m = clazz.getRawClass().getMethod("testMe", Float.TYPE, Float.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        MethodStatement ms = new MethodStatement((TestCase)test, method, callee, Arrays.asList(floatVar0, floatVar1));
        test.addStatement((StatementInterface)ms);
        System.out.println(test);
        TestSuiteChromosome suite = new TestSuiteChromosome();
        BranchCoverageSuiteFitness fitness = new BranchCoverageSuiteFitness();
        BranchCoverageMap.getInstance().searchStarted(null);
        Assert.assertEquals((double)4.0, (double)fitness.getFitness((AbstractTestSuiteChromosome)suite), (double)0.1f);
        suite.addTest((TestCase)test);
        Assert.assertEquals((double)1.0, (double)fitness.getFitness((AbstractTestSuiteChromosome)suite), (double)0.1f);
        System.out.println("Test suite: " + suite);
        TestSuiteLocalSearch localSearch = TestSuiteLocalSearch.getLocalSearch();
        DefaultLocalSearchObjective localObjective = new DefaultLocalSearchObjective((FitnessFunction)fitness);
        localSearch.doSearch((Chromosome)suite, (LocalSearchObjective)localObjective);
        System.out.println("Fitness: " + fitness.getFitness((AbstractTestSuiteChromosome)suite));
        System.out.println("Test suite: " + suite);
        Assert.assertEquals((double)0.0, (double)fitness.getFitness((AbstractTestSuiteChromosome)suite), (double)0.1f);
        BranchCoverageMap.getInstance().searchFinished(null);
    }

    @Test
    public void testFloatLocalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = FloatLocalSearchExample.class.getCanonicalName();
        Properties.LOCAL_SEARCH_RATE = 2;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.TESTS;
        Properties.LOCAL_SEARCH_REFERENCES = false;
        Properties.LOCAL_SEARCH_ARRAYS = false;
        Properties.CHROMOSOME_LENGTH = 5;
        Properties.MAX_INITIAL_TESTS = 2;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testDoubleGlobalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DoubleLocalSearchExample.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Did not expect optimal coverage", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleLocalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DoubleLocalSearchExample.class.getCanonicalName();
        Properties.LOCAL_SEARCH_RATE = 2;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.TESTS;
        Properties.LOCAL_SEARCH_REFERENCES = false;
        Properties.LOCAL_SEARCH_ARRAYS = false;
        Properties.CHROMOSOME_LENGTH = 5;
        Properties.MAX_INITIAL_TESTS = 2;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testStringGlobalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = StringLocalSearchExample.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Did not expect optimal coverage", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testStringLocalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = StringLocalSearchExample.class.getCanonicalName();
        Properties.LOCAL_SEARCH_RATE = 2;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.TESTS;
        Properties.LOCAL_SEARCH_REFERENCES = false;
        Properties.LOCAL_SEARCH_ARRAYS = false;
        Properties.CHROMOSOME_LENGTH = 5;
        Properties.MAX_INITIAL_TESTS = 2;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testArrayGlobalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ArrayLocalSearchExample.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 50000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Did not expect optimal coverage", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testArrayLocalSearch() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ArrayLocalSearchExample.class.getCanonicalName();
        Properties.LOCAL_SEARCH_RATE = 2;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.SUITES;
        Properties.LOCAL_SEARCH_BUDGET = 1L;
        Properties.LOCAL_SEARCH_REFERENCES = false;
        Properties.LOCAL_SEARCH_ARRAYS = true;
        Properties.SEARCH_BUDGET = 50000L;
        Properties.CHROMOSOME_LENGTH = 5;
        Properties.MAX_INITIAL_TESTS = 2;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }
}

