/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.examples.with.different.packagename.pool.ClassDependingOnExceptionClass;
import com.examples.with.different.packagename.pool.DependencyClass;
import com.examples.with.different.packagename.pool.DependencyClassWithException;
import com.examples.with.different.packagename.pool.DependencySubClass;
import com.examples.with.different.packagename.pool.OtherClass;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.seeding.ObjectPool;
import org.evosuite.seeding.ObjectPoolManager;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPool
extends SystemTest {
    private String pools = "";
    private double pPool = 0.0;
    private long budget = 0L;

    @Before
    public void storeProperties() {
        this.pools = Properties.OBJECT_POOLS;
        this.pPool = Properties.P_OBJECT_POOL;
        this.budget = Properties.SEARCH_BUDGET;
    }

    @After
    public void restoreProperties() {
        Properties.OBJECT_POOLS = this.pools;
        Properties.P_OBJECT_POOL = this.pPool;
        Properties.SEARCH_BUDGET = this.budget;
    }

    @Test
    public void testPoolDependency() throws IOException {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DependencyClass.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 100000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
    }

    @Test
    public void testPool() throws IOException {
        String targetClass;
        File f = File.createTempFile("EvoSuiteTestPool", null, FileUtils.getTempDirectory());
        String filename = f.getAbsolutePath();
        f.delete();
        System.out.println(filename);
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DependencyClass.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 100000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        ObjectPool pool = ObjectPool.getPoolFromTestSuite((TestSuiteChromosome)best);
        pool.writePool(filename);
        System.out.println("EvolvedTestSuite:\n" + best);
        this.resetStaticVariables();
        this.setDefaultPropertiesForTestCases();
        Properties.TARGET_CLASS = targetClass = OtherClass.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 1.0;
        Properties.OBJECT_POOLS = filename;
        Properties.SEARCH_BUDGET = 10000L;
        ObjectPoolManager.getInstance().initialisePool();
        command = new String[]{"-generateSuite", "-class", targetClass, "-Dobject_pools=" + filename};
        result = evosuite.parseCommandLine(command);
        ga = this.getGAFromResult(result);
        TestSuiteChromosome best2 = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best2);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best2.getCoverage(), (double)0.001);
        f = new File(filename);
        f.delete();
    }

    @Test
    public void testNoPool() throws IOException {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = OtherClass.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 0.0;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Expected non-optimal coverage: ", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testPoolWithSubClass() throws IOException {
        String targetClass;
        File f = File.createTempFile("EvoSuiteTestPool", null, FileUtils.getTempDirectory());
        String filename = f.getAbsolutePath();
        f.delete();
        System.out.println(filename);
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DependencySubClass.class.getCanonicalName();
        Properties.SEARCH_BUDGET = 50000L;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        ObjectPool pool = ObjectPool.getPoolFromTestSuite((TestSuiteChromosome)best);
        pool.writePool(filename);
        System.out.println("EvolvedTestSuite:\n" + best);
        this.resetStaticVariables();
        this.setDefaultPropertiesForTestCases();
        Properties.TARGET_CLASS = targetClass = OtherClass.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 1.0;
        Properties.OBJECT_POOLS = filename;
        ObjectPoolManager.getInstance().initialisePool();
        command = new String[]{"-generateSuite", "-class", targetClass, "-Dobject_pools=" + filename};
        result = evosuite.parseCommandLine(command);
        ga = this.getGAFromResult(result);
        best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
        f = new File(filename);
        f.delete();
    }

    @Test
    public void testPoolWithException() throws IOException {
        String targetClass;
        File f = File.createTempFile("EvoSuiteTestPool", null, FileUtils.getTempDirectory());
        String filename = f.getAbsolutePath();
        f.delete();
        System.out.println(filename);
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = DependencyClassWithException.class.getCanonicalName();
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        ObjectPool pool = ObjectPool.getPoolFromTestSuite((TestSuiteChromosome)best);
        pool.writePool(filename);
        System.out.println("EvolvedTestSuite:\n" + best);
        this.resetStaticVariables();
        this.setDefaultPropertiesForTestCases();
        Properties.TARGET_CLASS = targetClass = ClassDependingOnExceptionClass.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 1.0;
        Properties.OBJECT_POOLS = filename;
        ObjectPoolManager.getInstance().initialisePool();
        command = new String[]{"-generateSuite", "-class", targetClass, "-Dobject_pools=" + filename};
        result = evosuite.parseCommandLine(command);
        ga = this.getGAFromResult(result);
        best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertEquals((String)"Non-optimal coverage: ", (double)1.0, (double)best.getCoverage(), (double)0.001);
        f = new File(filename);
        f.delete();
    }

    @Test
    public void testNoPoolWithException() throws IOException {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ClassDependingOnExceptionClass.class.getCanonicalName();
        Properties.P_OBJECT_POOL = 0.0;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        Assert.assertTrue((String)"Non-optimal coverage: ", (best.getCoverage() < 1.0 ? 1 : 0) != 0);
    }
}

