/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import com.examples.with.different.packagename.ReadFromSystemIn;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.SystemTest;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SystemInUtilSystemTest
extends SystemTest {
    private static final boolean defaultSystemIn = Properties.REPLACE_SYSTEM_IN;
    private static final boolean defaultVFS = Properties.VIRTUAL_FS;

    @After
    public void tearDown() {
        Properties.REPLACE_SYSTEM_IN = defaultSystemIn;
        Properties.VIRTUAL_FS = defaultVFS;
    }

    @Test
    public void testWithNoVFS() {
        Properties.VIRTUAL_FS = false;
        this._test();
    }

    @Test
    public void testWithVFS() {
        Properties.VIRTUAL_FS = true;
        this._test();
    }

    private void _test() {
        String targetClass;
        EvoSuite evosuite = new EvoSuite();
        Properties.TARGET_CLASS = targetClass = ReadFromSystemIn.class.getCanonicalName();
        Properties.REPLACE_SYSTEM_IN = true;
        String[] command = new String[]{"-generateSuite", "-class", targetClass};
        Object result = evosuite.parseCommandLine(command);
        GeneticAlgorithm<?> ga = this.getGAFromResult(result);
        TestSuiteChromosome best = (TestSuiteChromosome)ga.getBestIndividual();
        System.out.println("EvolvedTestSuite:\n" + best);
        int goals = ((TestFitnessFactory)TestSuiteGenerator.getFitnessFactory().get(0)).getCoverageGoals().size();
        Assert.assertEquals((long)3L, (long)goals);
        double coverage = best.getCoverage();
        Assert.assertTrue((String)("Not good enough coverage: " + coverage), (coverage > 0.99 ? 1 : 0) != 0);
    }
}

