/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import org.evosuite.rmi.MasterServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.utils.Listener;

public class ConsoleProgressBar
implements Listener<ClientStateInformation> {
    private static final long serialVersionUID = 8930332599188240933L;

    public static void startProgressBar() {
        MasterServices.getInstance().getMasterNode().addListener(new ConsoleProgressBar());
    }

    public void receiveEvent(ClientStateInformation event) {
        int i;
        if (event.getState() != ClientState.SEARCH) {
            return;
        }
        int percent = event.getProgress();
        int coverage = event.getCoverage();
        StringBuilder bar = new StringBuilder("[Progress:");
        for (i = 0; i < 30; ++i) {
            if (i < (int)((double)percent * 0.3)) {
                bar.append("=");
                continue;
            }
            if (i == (int)((double)percent * 0.3)) {
                bar.append(">");
                continue;
            }
            bar.append(" ");
        }
        bar.append(Math.min(100, percent) + "%] [Cov:");
        for (i = 0; i < 35; ++i) {
            if (i < (int)((double)coverage * 0.35)) {
                bar.append("=");
                continue;
            }
            if (i == (int)((double)coverage * 0.35)) {
                bar.append(">");
                continue;
            }
            bar.append(" ");
        }
        bar.append(coverage + "%]");
        System.out.print("\r" + bar.toString());
    }
}

