/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous;

import org.evosuite.Properties;

public class CtgConfiguration {
    protected final int MINIMUM_MEMORY_PER_JOB_MB = 500;
    public final int totalMemoryInMB;
    public final int numberOfCores;
    public final int timeInMinutes;
    public final int minMinutesPerJob;
    public final boolean callHome;
    public final Properties.AvailableSchedule schedule;

    public CtgConfiguration(int totalMemoryInMB, int numberOfCores, int timeInMinutes, int minMinutesPerJob, boolean callHome, Properties.AvailableSchedule schedule) {
        this.totalMemoryInMB = totalMemoryInMB;
        this.numberOfCores = numberOfCores;
        this.timeInMinutes = timeInMinutes;
        this.minMinutesPerJob = minMinutesPerJob;
        this.callHome = callHome;
        this.schedule = schedule;
    }

    public static CtgConfiguration getFromParameters() {
        return new CtgConfiguration(Properties.CTG_MEMORY, Properties.CTG_CORES, Properties.CTG_TIME, Properties.CTG_MIN_TIME_PER_JOB, false, Properties.CTG_SCHEDULE);
    }

    public CtgConfiguration getWithChangedTime(int minutesPerClass, int numberOfCUTs) throws IllegalArgumentException {
        if (minutesPerClass < 0) {
            throw new IllegalArgumentException("Invalid value for minutesPerClass:" + minutesPerClass);
        }
        if (numberOfCUTs < 0) {
            throw new IllegalArgumentException("Invalid value for numberOfCUTs:" + numberOfCUTs);
        }
        int time = (int)Math.ceil((double)(minutesPerClass * numberOfCUTs) / (double)this.getNumberOfUsableCores());
        return new CtgConfiguration(this.totalMemoryInMB, this.numberOfCores, time, this.minMinutesPerJob, this.callHome, this.schedule);
    }

    public int getNumberOfUsableCores() {
        if (this.numberOfCores * 500 <= this.totalMemoryInMB) {
            return this.numberOfCores;
        }
        return this.totalMemoryInMB / 500;
    }

    public int getConstantMemoryPerJob() {
        return this.totalMemoryInMB / this.getNumberOfUsableCores();
    }
}

