/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.continuous.CtgConfiguration;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.schedule.BudgetAndSeedingSchedule;
import org.evosuite.continuous.job.schedule.BudgetSchedule;
import org.evosuite.continuous.job.schedule.HistorySchedule;
import org.evosuite.continuous.job.schedule.ScheduleType;
import org.evosuite.continuous.job.schedule.SeedingSchedule;
import org.evosuite.continuous.job.schedule.SimpleSchedule;
import org.evosuite.continuous.project.ProjectStaticData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobScheduler {
    private static Logger logger = LoggerFactory.getLogger(JobScheduler.class);
    private final ProjectStaticData projectData;
    protected final CtgConfiguration configuration;
    private ScheduleType currentSchedule;

    public JobScheduler(ProjectStaticData projectData, CtgConfiguration conf) {
        this.projectData = projectData;
        this.configuration = conf;
        this.chooseScheduleType(this.configuration.schedule);
    }

    public void chooseScheduleType(Properties.AvailableSchedule schedule) throws IllegalArgumentException {
        switch (schedule) {
            case SIMPLE: {
                this.currentSchedule = new SimpleSchedule(this);
                break;
            }
            case BUDGET: {
                this.currentSchedule = new BudgetSchedule(this);
                break;
            }
            case SEEDING: {
                this.currentSchedule = new SeedingSchedule(this);
                break;
            }
            case BUDGET_AND_SEEDING: {
                this.currentSchedule = new BudgetAndSeedingSchedule(this);
                break;
            }
            case HISTORY: {
                this.currentSchedule = new HistorySchedule(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Schedule '" + schedule + "' is not supported");
            }
        }
    }

    public List<JobDefinition> createNewSchedule() {
        if (!this.canExecuteMore()) {
            logger.info("Cannot schedule more jobs");
            return null;
        }
        logger.info("Creating new schedule with " + this.currentSchedule.getClass().getSimpleName());
        return this.currentSchedule.createNewSchedule();
    }

    public boolean canExecuteMore() {
        return this.currentSchedule.canExecuteMore();
    }

    public ProjectStaticData getProjectData() {
        return this.projectData;
    }

    public CtgConfiguration getConfiguration() {
        return this.configuration;
    }
}

