/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.persistency;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import org.evosuite.statistics.RuntimeVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvJUnitData {
    private static Logger logger = LoggerFactory.getLogger(CsvJUnitData.class);
    private String targetClass;
    private double branchCoverage;
    private int totalNumberOfStatements;
    private int numberOfTests;
    private int totalNumberOfFailures;
    private int durationInSeconds;
    private int configurationId;

    protected CsvJUnitData() {
    }

    public static CsvJUnitData openFile(File file) {
        if (!file.getName().endsWith("csv")) {
            logger.error("Not a csv file: " + file.getAbsolutePath());
            return null;
        }
        List rows = null;
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(file));
            rows = reader.readAll();
            reader.close();
        }
        catch (Exception e) {
            logger.error("Exception while parsing CSV file " + file.getAbsolutePath() + " , " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (rows.size() != 2) {
            logger.error("Cannot parse " + file.getAbsolutePath() + " as it has " + rows.size() + " rows");
            return null;
        }
        CsvJUnitData data = new CsvJUnitData();
        try {
            data.targetClass = CsvJUnitData.getValue(rows, "TARGET_CLASS").trim();
            data.configurationId = 0;
            data.branchCoverage = Double.parseDouble(CsvJUnitData.getValue(rows, RuntimeVariable.BranchCoverage.toString()));
            data.totalNumberOfStatements = Integer.parseInt(CsvJUnitData.getValue(rows, RuntimeVariable.Length.toString()));
            data.durationInSeconds = Integer.parseInt(CsvJUnitData.getValue(rows, RuntimeVariable.Total_Time.toString())) / 1000;
            data.numberOfTests = Integer.parseInt(CsvJUnitData.getValue(rows, RuntimeVariable.Size.toString()));
            data.totalNumberOfFailures = 0;
        }
        catch (Exception e) {
            logger.error("Error while parsing CSV file: " + e, (Throwable)e);
            return null;
        }
        return data;
    }

    public static String getValue(List<String[]> rows, String columnName) {
        String[] names = rows.get(0);
        String[] values = rows.get(1);
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].trim().equalsIgnoreCase(columnName.trim())) continue;
            return values[i].trim();
        }
        return null;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public double getBranchCoverage() {
        return this.branchCoverage;
    }

    public int getTotalNumberOfStatements() {
        return this.totalNumberOfStatements;
    }

    public int getNumberOfTests() {
        return this.numberOfTests;
    }

    public int getTotalNumberOfFailures() {
        return this.totalNumberOfFailures;
    }

    public int getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public int getConfigurationId() {
        return this.configurationId;
    }
}

