/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.project;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.classpath.ResourceList;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.junit.CoverageAnalysis;
import org.evosuite.runtime.sandbox.Sandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectAnalyzer {
    private static Logger logger = LoggerFactory.getLogger(ProjectAnalyzer.class);
    private final String target;
    private final String prefix;
    private transient Set<String> cutsToAnalyze;
    private boolean validateCutsToAnalyze;

    public ProjectAnalyzer(String target, String prefix, String[] cuts) {
        this.target = target;
        this.prefix = prefix == null ? "" : prefix;
        this.validateCutsToAnalyze = true;
        if (cuts == null) {
            this.cutsToAnalyze = null;
        } else {
            this.cutsToAnalyze = new LinkedHashSet<String>();
            for (String s : cuts) {
                if (s == null || s.isEmpty()) continue;
                this.cutsToAnalyze.add(s.trim());
            }
        }
    }

    public ProjectAnalyzer(String[] cuts) throws NullPointerException {
        if (cuts == null) {
            throw new NullPointerException("Input array cannot be null");
        }
        this.target = null;
        this.prefix = null;
        this.validateCutsToAnalyze = false;
        this.cutsToAnalyze = new LinkedHashSet<String>();
        this.cutsToAnalyze.addAll(Arrays.asList(cuts));
    }

    private Collection<String> getCutsToAnalyze() {
        if (this.cutsToAnalyze != null && !this.validateCutsToAnalyze) {
            return this.cutsToAnalyze;
        }
        Set suts = null;
        if (this.target != null) {
            if (!this.target.contains(File.pathSeparator)) {
                suts = ResourceList.getAllClasses((String)this.target, (String)this.prefix, (boolean)false);
            } else {
                suts = new LinkedHashSet();
                for (String element : this.target.split(File.pathSeparator)) {
                    suts.addAll(ResourceList.getAllClasses((String)element, (String)this.prefix, (boolean)false));
                }
            }
        } else {
            suts = ResourceList.getAllClasses((String)ClassPathHandler.getInstance().getTargetProjectClasspath(), (String)this.prefix, (boolean)false);
        }
        LinkedList<String> cuts = new LinkedList<String>();
        for (String className : suts) {
            if (this.cutsToAnalyze != null && !this.cutsToAnalyze.contains(className)) continue;
            try {
                Class<?> clazz = Class.forName(className);
                if (CoverageAnalysis.isTest(clazz)) continue;
                cuts.add(className);
            }
            catch (ClassNotFoundException e) {
                logger.error("" + e, (Throwable)e);
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError e) {
                logger.warn("Cannot initialize class: " + className);
            }
        }
        return cuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectStaticData analyze() {
        ProjectStaticData data = new ProjectStaticData();
        if (Properties.CTG_SCHEDULE.equals((Object)Properties.AvailableSchedule.HISTORY)) {
            data.initializeLocalHistory();
        }
        for (String className : this.getCutsToAnalyze()) {
            Class<?> theClass = null;
            int numberOfBranches = -1;
            boolean hasCode = false;
            Properties.TARGET_CLASS = className;
            InstrumentingClassLoader instrumenting = new InstrumentingClassLoader();
            BranchPool.reset();
            try {
                Sandbox.goingToExecuteUnsafeCodeOnSameThread();
                instrumenting.loadClass(className);
                numberOfBranches = BranchPool.getBranchCounter();
                hasCode = numberOfBranches > 0 || BranchPool.getBranchlessMethods().size() > 0;
                theClass = ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (Exception e) {
                logger.warn("Cannot handle " + className + " due to: " + e.getClass() + " " + e.getMessage());
                continue;
            }
            finally {
                Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
                BranchPool.reset();
                Properties.TARGET_CLASS = "";
                continue;
            }
            ProjectStaticData.ClassInfo ci = new ProjectStaticData.ClassInfo(theClass, numberOfBranches, hasCode);
            data.addNewClass(ci);
            if (Properties.CTG_SCHEDULE != Properties.AvailableSchedule.HISTORY) continue;
            ci.setChanged(data.hasChanged(theClass.getCanonicalName()));
            ci.setCoverageImproved(data.hasCoverageImproved(theClass.getCanonicalName(), 3));
        }
        return data;
    }
}

