/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.project;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.seeding.CastClassAnalyzer;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.InheritanceTreeGenerator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectGraph {
    private static final Logger logger = LoggerFactory.getLogger(ProjectGraph.class);
    private final InheritanceTree inheritanceTree;
    private final Map<String, Set<String>> castInformation;
    private final ProjectStaticData data;

    public ProjectGraph(ProjectStaticData data) {
        this.data = data;
        this.inheritanceTree = InheritanceTreeGenerator.createFromClassList(data.getClassNames());
        this.castInformation = new HashMap<String, Set<String>>();
        if (logger.isDebugEnabled()) {
            logger.debug("Classes in inheritance tree: " + this.inheritanceTree.getAllClasses());
        }
    }

    public Set<String> getCUTsDirectlyUsedAsInput(String cut, boolean includeSubclasses) throws IllegalArgumentException {
        this.checkCUT(cut);
        Set<String> parameterClasses = this.recursionToSearchDirectInputs(cut, includeSubclasses);
        parameterClasses.remove(cut);
        this.removeNonCUT(parameterClasses);
        logger.debug("Parameter classes of " + cut + ": " + parameterClasses);
        return parameterClasses;
    }

    protected Set<String> recursionToSearchDirectInputs(String aClass, boolean includeSubclasses) {
        if (includeSubclasses) {
            Set<String> directlyUsed = this.recursionToSearchDirectInputs(aClass, false);
            LinkedHashSet<String> all = new LinkedHashSet<String>(directlyUsed);
            for (String name : directlyUsed) {
                all.addAll(this.getAllCUTsSubclasses(name));
            }
            return all;
        }
        Set<String> parameterClasses = this.getParameterClasses(aClass);
        parameterClasses.addAll(this.getCastClasses(aClass));
        return parameterClasses;
    }

    public Set<String> getCUTsThatUseThisCUTasInput(String cut, boolean includeSuperClasses) throws IllegalArgumentException {
        this.checkCUT(cut);
        Set<String> classNames = this.recursionToSearchWhatUsesItAsInput(cut, includeSuperClasses);
        classNames.remove(cut);
        this.removeNonCUT(classNames);
        return classNames;
    }

    protected Set<String> recursionToSearchWhatUsesItAsInput(String aClass, boolean includeSuperClasses) {
        if (includeSuperClasses) {
            Set<String> directlyUsed = this.recursionToSearchWhatUsesItAsInput(aClass, false);
            LinkedHashSet<String> all = new LinkedHashSet<String>(directlyUsed);
            for (String name : this.getAllCUTsParents(aClass)) {
                all.addAll(this.recursionToSearchWhatUsesItAsInput(name, false));
            }
            return all;
        }
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        for (String className : this.inheritanceTree.getAllClasses()) {
            Set<String> inputClasses;
            if (className.equals(aClass) || !(inputClasses = this.getCUTsDirectlyUsedAsInput(className, true)).contains(aClass)) continue;
            classNames.add(className);
        }
        return classNames;
    }

    public boolean isInterface(String className) throws IllegalArgumentException {
        this.checkClass(className);
        ClassNode node = this.getClassNode(className);
        return (node.access & 0x200) == 512;
    }

    public boolean isConcrete(String className) throws IllegalArgumentException {
        this.checkClass(className);
        return !this.isInterface(className) && !this.isAbstract(className);
    }

    public boolean isAbstract(String className) throws IllegalArgumentException {
        this.checkClass(className);
        ClassNode node = this.getClassNode(className);
        return (node.access & 0x400) == 1024;
    }

    private void checkClass(String className) throws IllegalArgumentException {
        if (!this.data.containsClass(className)) {
            throw new IllegalArgumentException("Class " + className + " is not part of the SUT");
        }
    }

    private void checkCUT(String cut) throws IllegalArgumentException {
        ProjectStaticData.ClassInfo info = this.data.getClassInfo(cut);
        if (info == null) {
            throw new IllegalArgumentException("Class " + cut + " is not part of the SUT");
        }
        if (!info.isTestable()) {
            throw new IllegalArgumentException("Class " + cut + " belongs to the SUT, but it is not a CUT (ie testable)");
        }
    }

    public Set<String> getAllCUTsSubclasses(String aClass) throws IllegalArgumentException {
        this.checkClass(aClass);
        Set set = null;
        try {
            set = this.inheritanceTree.getSubclasses(aClass);
        }
        catch (Exception e) {
            logger.error("Bug in inheritanceTree: " + e);
            return new HashSet<String>();
        }
        set.remove(aClass);
        this.removeNonCUT(set);
        return set;
    }

    public Set<String> getAllCUTsParents(String aClass) throws IllegalArgumentException {
        this.checkClass(aClass);
        Set set = null;
        try {
            set = this.inheritanceTree.getSuperclasses(aClass);
        }
        catch (Exception e) {
            logger.error("Bug in inheritanceTree: " + e);
            return new HashSet<String>();
        }
        set.remove(aClass);
        this.removeNonCUT(set);
        return set;
    }

    private void removeNonCUT(Set<String> set) throws IllegalArgumentException {
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            ProjectStaticData.ClassInfo info = this.data.getClassInfo(name);
            if (info == null) {
                throw new IllegalArgumentException("Class " + name + " does not belong to the SUT");
            }
            if (info.isTestable()) continue;
            iter.remove();
        }
    }

    private ClassNode getClassNode(String className) {
        return DependencyAnalysis.getClassNode((String)className);
    }

    private Set<String> getCastClasses(String className) {
        if (!this.castInformation.containsKey(className)) {
            CastClassAnalyzer analyzer = new CastClassAnalyzer();
            Map castMap = analyzer.analyze(className);
            LinkedHashSet<String> castClasses = new LinkedHashSet<String>();
            for (Type type : castMap.keySet()) {
                String name = type.getClassName();
                if (!this.inheritanceTree.hasClass(name)) continue;
                castClasses.add(name);
            }
            this.castInformation.put(className, castClasses);
        }
        return this.castInformation.get(className);
    }

    private Set<String> getParameterClasses(String cut) {
        LinkedHashSet<String> parameters = new LinkedHashSet<String>();
        ClassNode node = this.getClassNode(cut);
        List methods = node.methods;
        for (MethodNode methodNode : methods) {
            this.addParameterClasses(methodNode, parameters);
        }
        List fields = node.fields;
        for (FieldNode fieldNode : fields) {
            this.addParameterClasses(fieldNode, parameters);
        }
        return parameters;
    }

    private void addParameterClasses(MethodNode methodNode, Set<String> classNames) {
        if ((methodNode.access & 1) != 1) {
            return;
        }
        for (Type parameterType : Type.getArgumentTypes((String)methodNode.desc)) {
            String name = parameterType.getClassName();
            if (!this.inheritanceTree.hasClass(name)) continue;
            classNames.add(name);
        }
    }

    private void addParameterClasses(FieldNode fieldNode, Set<String> classNames) {
        if ((fieldNode.access & 1) != 1) {
            return;
        }
        String name = Type.getType((String)fieldNode.desc).getClassName();
        if (this.inheritanceTree.hasClass(name)) {
            classNames.add(name);
        }
    }
}

