/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.project;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.Properties;
import org.evosuite.continuous.persistency.CsvJUnitData;
import org.evosuite.continuous.project.ProjectGraph;
import org.evosuite.statistics.RuntimeVariable;

public class ProjectStaticData {
    private final Map<String, ClassInfo> classes = new ConcurrentHashMap<String, ClassInfo>();
    private final Set<String> filesChanged = new HashSet<String>();
    private final HashMap<String, List<Double>> coverage = new HashMap();
    private ProjectGraph graph = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeLocalHistory() {
        File tmp;
        Object[] tmp_dirs;
        BufferedReader br = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new FileReader(Properties.CTG_HISTORY_FILE));
            while ((sCurrentLine = br.readLine()) != null) {
                String[] split = sCurrentLine.split(",");
                this.filesChanged.add(split[0]);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if ((tmp_dirs = (tmp = new File(Properties.CTG_FOLDER + "/" + Properties.CTG_TMP_FOLDER)).listFiles()) == null || tmp_dirs.length == 0) {
            return;
        }
        Arrays.sort(tmp_dirs);
        for (Object tmp_dir : tmp_dirs) {
            File subjects;
            if (((File)tmp_dir).getName().equals(Properties.SEED_DIR) || !((File)tmp_dir).isDirectory() || (subjects = new File(((File)tmp_dir).getAbsolutePath() + "/reports")).listFiles() == null) continue;
            for (File subject : subjects.listFiles()) {
                if (!subject.isDirectory()) continue;
                List rows = null;
                try {
                    CSVReader reader = new CSVReader((Reader)new FileReader(subject.getAbsolutePath() + "/statistics.csv"));
                    rows = reader.readAll();
                    reader.close();
                }
                catch (Exception e) {
                    continue;
                }
                if (rows == null || rows.isEmpty()) continue;
                String targetClass = CsvJUnitData.getValue(rows, "TARGET_CLASS").trim();
                double branchCoverage = Double.parseDouble(CsvJUnitData.getValue(rows, RuntimeVariable.BranchCoverage.toString()));
                ArrayList<Double> class_coverages = this.coverage.containsKey(targetClass) ? this.coverage.get(targetClass) : new ArrayList<Double>();
                class_coverages.add(branchCoverage);
                this.coverage.put(targetClass, class_coverages);
            }
        }
    }

    protected void addNewClass(ClassInfo info) {
        this.classes.put(info.getClassName(), info);
    }

    public boolean containsClass(String c) {
        return this.classes.containsKey(c);
    }

    public ClassInfo getClassInfo(String name) {
        return this.classes.get(name);
    }

    public int getTotalNumberOfClasses() {
        return this.classes.size();
    }

    public int getTotalNumberOfTestableCUTs() {
        int total = 0;
        for (ClassInfo info : this.classes.values()) {
            if (!info.isTestable()) continue;
            ++total;
        }
        return total;
    }

    public int getTotalNumberOfBranches() {
        int total = 0;
        for (ClassInfo info : this.classes.values()) {
            total += info.numberOfBranches;
        }
        return total;
    }

    public Collection<ClassInfo> getClassInfos() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Collection<String> getClassNames() {
        return Collections.unmodifiableCollection(this.classes.keySet());
    }

    public boolean hasChanged(String className) {
        return this.filesChanged.contains(className);
    }

    public List<Double> getPreviousCoverage(String className) {
        return this.coverage.get(className);
    }

    public boolean hasCoverageImproved(String className, int n) {
        double lastCoverage = 0.0;
        try {
            lastCoverage = this.coverage.get(className).get(this.coverage.get(className).size() - 1);
            if (lastCoverage == 1.0) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return true;
        }
        if (this.coverage.get(className).size() < n) {
            return true;
        }
        for (int i = this.coverage.get(className).size() - 2; i > this.coverage.get(className).size() - 1 - n; --i) {
            if (i < 0) {
                return false;
            }
            if (!(this.coverage.get(className).get(i) < lastCoverage)) continue;
            return true;
        }
        return false;
    }

    public ProjectGraph getProjectGraph() {
        if (this.graph == null) {
            this.graph = new ProjectGraph(this);
        }
        return this.graph;
    }

    public static class ClassInfo {
        public final Class<?> theClass;
        public final int numberOfBranches;
        public final boolean hasCode;
        private boolean hasChanged = true;
        private boolean hasCoverageImproved = true;

        public ClassInfo(Class<?> theClass, int numberOfBranches, boolean hasCode) {
            this.theClass = theClass;
            this.numberOfBranches = numberOfBranches;
            this.hasCode = hasCode;
        }

        public String getClassName() {
            return this.theClass.getName();
        }

        public boolean isTestable() {
            return this.hasCode;
        }

        public void setChanged(boolean changed) {
            this.hasChanged = changed;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }

        public void setCoverageImproved(boolean coverage) {
            this.hasCoverageImproved = coverage;
        }

        public boolean hasCoverageImproved() {
            return this.hasCoverageImproved;
        }
    }
}

