/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.executionmode;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.classpath.ResourceList;
import org.evosuite.executionmode.Help;
import org.evosuite.utils.LoggingUtils;

public class ListClasses {
    public static final String NAME = "listClasses";

    public static Option getOption() {
        return new Option(NAME, "list the testable classes found in the specified classpath/prefix");
    }

    public static Object execute(Options options, CommandLine line) {
        if (line.hasOption("prefix")) {
            ListClasses.listClassesPrefix(line.getOptionValue("prefix"));
        } else if (line.hasOption("target")) {
            ListClasses.listClassesTarget(line.getOptionValue("target"));
        } else if (EvoSuite.hasLegacyTargets()) {
            ListClasses.listClassesLegacy();
        } else {
            LoggingUtils.getEvoLogger().error("Please specify target prefix ('-prefix' option) or classpath entry ('-target' option) to list testable classes");
            Help.execute(options);
        }
        return null;
    }

    private static void listClassesTarget(String target) {
        Set classes = ResourceList.getAllClasses((String)target, (boolean)false);
        try {
            ClassPathHacker.addFile((String)target);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (String sut : classes) {
            block7: {
                try {
                    if (ResourceList.isClassAnInterface((String)sut) || ResourceList.isClassDeprecated((String)sut)) continue;
                    if (!ResourceList.isClassTestable((String)sut)) {
                    }
                    break block7;
                }
                catch (IOException e) {
                    LoggingUtils.getEvoLogger().error("Could not load class: " + sut);
                }
                continue;
            }
            String row = "";
            String groupId = Properties.GROUP_ID;
            if (groupId != null && !groupId.isEmpty() && !groupId.equals("none")) {
                row = row + groupId + "\t";
            }
            row = row + sut;
            LoggingUtils.getEvoLogger().info(row);
        }
    }

    private static void listClassesLegacy() {
        File directory = new File(Properties.OUTPUT_DIR);
        String[] extensions = new String[]{"task"};
        for (File file : FileUtils.listFiles((File)directory, (String[])extensions, (boolean)false)) {
            LoggingUtils.getEvoLogger().info(file.getName().replace(".task", ""));
        }
    }

    private static void listClassesPrefix(String prefix) {
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        LinkedHashSet classes = new LinkedHashSet();
        for (String classPathElement : cp.split(File.pathSeparator)) {
            classes.addAll(ResourceList.getAllClasses((String)classPathElement, (String)prefix, (boolean)false));
            try {
                ClassPathHacker.addFile((String)classPathElement);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (String sut : classes) {
            block7: {
                try {
                    if (ResourceList.isClassAnInterface((String)sut)) {
                    }
                    break block7;
                }
                catch (IOException e) {
                    LoggingUtils.getEvoLogger().error("Could not load class: " + sut);
                }
                continue;
            }
            LoggingUtils.getEvoLogger().info(sut);
        }
    }
}

